/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React, {ReactElement} from 'react';

export function KaravanIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            id="svg50"
            width={32}
            height={32}
            preserveAspectRatio="xMidYMid"
            version="1.1"
            viewBox="0 0 256 256"
            className={className ? className : "logo"}
        >
            <defs id="defs31">
                <linearGradient id="linearGradient1351">
                    <stop
                        id="stop1347"
                        offset="0"
                        stopColor="#dcffff"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop1349"
                        offset="1"
                        stopColor="#96d2e6"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <circle id="path-1" cx="128" cy="128" r="128"></circle>
                <linearGradient
                    id="linearGradient-3"
                    x1="-26.051"
                    x2="254.316"
                    y1="271.331"
                    y2="0.048"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop
                        id="stop10"
                        offset="0%"
                        stopColor="#4790bb"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop12"
                        offset="10.996%"
                        stopColor="#64b7db"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop14"
                        offset="94.502%"
                        stopColor="#326ea0"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-4"
                    x1="-32.163"
                    x2="259.338"
                    y1="277.029"
                    y2="-5.028"
                    gradientUnits="userSpaceOnUse"
                >
                    <stop id="stop17" offset="0%" stopColor="#F69923"></stop>
                    <stop id="stop19" offset="8.048%" stopColor="#F79A23"></stop>
                    <stop id="stop21" offset="41.874%" stopColor="#E97826"></stop>
                </linearGradient>
                <linearGradient
                    id="linearGradient-5"
                    x1="217.945"
                    x2="99.459"
                    y1="67.505"
                    y2="247.005"
                    gradientTransform="scale(.96442 1.0369)"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient-4"
                >
                    <stop
                        id="stop24"
                        offset="0%"
                        stopColor="#92d6d5"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop26"
                        offset="41.191%"
                        stopColor="#79b7cc"
                        stopOpacity="1"
                    ></stop>
                    <stop
                        id="stop28"
                        offset="73.271%"
                        stopColor="#5891c5"
                        stopOpacity="1"
                    ></stop>
                </linearGradient>
                <mask id="mask-2" fill="#fff">
                    <use id="use33" xlinkHref="#path-1"></use>
                </mask>
                <mask id="mask-2-7" fill="#fff">
                    <use id="use137" xlinkHref="#path-1"></use>
                </mask>
                <linearGradient
                    id="linearGradient1345"
                    x1="233.122"
                    x2="2.24"
                    y1="56.015"
                    y2="242.78"
                    gradientUnits="userSpaceOnUse"
                    xlinkHref="#linearGradient1351"
                ></linearGradient>
            </defs>
            <circle
                id="circle38"
                cx="127.994"
                cy="127.994"
                r="123.111"
                fill="url(#linearGradient-3)"
                fillRule="nonzero"
                mask="url(#mask-2)"
            ></circle>
            <g id="g2266">
                <path
                    id="path42"
                    fill="url(#linearGradient-5)"
                    fillOpacity="1"
                    fillRule="nonzero"
                    d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412z"
                    mask="url(#mask-2)"
                    opacity="0.75"
                ></path>
            </g>
            <path
                id="path44"
                fill="#1e4b7b"
                fillOpacity="1"
                fillRule="nonzero"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513z"
                mask="url(#mask-2)"
                opacity="0.75"
            ></path>
            <path
                id="path150"
                fill="url(#linearGradient1345)"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488z"
                mask="url(#mask-2-7)"
                transform="translate(-.769 -.133)"
            ></path>
            <path
                id="path40"
                fill="#2d4150"
                fillOpacity="1"
                fillRule="nonzero"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232z"
                mask="url(#mask-2)"
                transform="translate(-.59) scale(1.00078)"
            ></path>
        </svg>
    );
}

export function CamelIcon(props?: (React.SVGProps<SVGSVGElement>) | undefined) {
    return (<svg
            xmlns="http://www.w3.org/2000/svg"
            xmlnsXlink="http://www.w3.org/1999/xlink"
            preserveAspectRatio="xMidYMid"
            viewBox="0 0 256 256"
            {...props}
            className="icon" width="32px" height="32px">
            <defs>
                <linearGradient
                    id="b"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="10.996%" stopColor="#F79A23"/>
                    <stop offset="94.502%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="d"
                    x1="-12.564%"
                    x2="101.304%"
                    y1="108.214%"
                    y2="-1.964%"
                >
                    <stop offset="0%" stopColor="#F69923"/>
                    <stop offset="8.048%" stopColor="#F79A23"/>
                    <stop offset="41.874%" stopColor="#E97826"/>
                </linearGradient>
                <linearGradient
                    id="e"
                    x1="74.724%"
                    x2="6.653%"
                    y1="-3.059%"
                    y2="100.066%"
                >
                    <stop offset="0%" stopColor="#F6E423"/>
                    <stop offset="41.191%" stopColor="#F79A23"/>
                    <stop offset="73.271%" stopColor="#E97826"/>
                </linearGradient>
                <circle id="a" cx={128} cy={128} r={128}/>
            </defs>
            <mask id="c" fill="#fff">
                <use xlinkHref="#a"/>
            </mask>
            <circle
                cx={127.994}
                cy={127.994}
                r={123.111}
                fill="url(#b)"
                mask="url(#c)"
            />
            <path
                fill="url(#d)"
                d="M128 256C57.308 256 0 198.692 0 128 0 57.308 57.308 0 128 0c70.692 0 128 57.308 128 128 0 70.692-57.308 128-128 128Zm0-9.768c65.298 0 118.232-52.934 118.232-118.232S193.298 9.768 128 9.768 9.768 62.702 9.768 128 62.702 246.232 128 246.232Z"
                mask="url(#c)"
            />
            <path
                fill="url(#e)"
                d="M98.044 75.517c-1.751-.002-3.524.01-5.292.061-2.056.06-4.817.713-8 1.785 53.775 40.834 73.108 114.497 39.875 178.514 1.129.03 2.249.123 3.385.123 60.736 0 111.492-42.323 124.609-99.071-38.542-45.178-90.813-81.314-154.578-81.412Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#28170B"
                d="M84.752 77.368C66.895 83.378 32.83 104.546.079 132.81c2.487 67.334 57.028 121.313 124.548 123.07 33.233-64.016 13.901-137.68-39.875-178.513Z"
                mask="url(#c)"
                opacity={0.75}
            />
            <path
                fill="#FFF"
                d="M128.747 54.005c-10.985 5.495 0 27.466 0 27.466C95.774 108.954 102.78 155.9 64.312 155.9c-20.97 0-42.242-24.077-64.233-38.828-.283 3.479-.785 6.972-.785 10.524 0 48.095 26.263 89.924 65.42 111.897 10.952-1.38 22.838-4.114 31.05-9.592 43.146-28.765 53.857-83.491 71.487-109.925 10.979-16.492 62.434-15.061 65.906-22.01 5.502-10.991-10.99-27.467-16.491-27.467h-43.958c-3.071 0-7.897-5.456-10.974-5.456h-16.492s-7.307-11.085-13.794-11.526c-.93-.066-1.83.053-2.7.488Z"
                mask="url(#c)"
            />
        </svg>
    );
}

export function getDesignerIcon(icon: string): ReactElement {
    if (icon === 'kamelet') return (
        <svg
            className="top-icon" id="icon"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 32 32"
            width="32px" height="32px"
        >
            <title>{"application"}</title>
            <path
                d="M16 18H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2ZM6 6v10h10V6ZM26 12v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM26 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2ZM16 22v4h-4v-4h4m0-2h-4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2v-4a2 2 0 0 0-2-2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
    if (icon === 'code') return (
        <svg

            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="24"
            fill="none"
            viewBox="0 0 24 24"
        >
            <path
                fill="#000000"
                d="M8.502 5.387a.75.75 0 00-1.004-1.115L5.761 5.836c-.737.663-1.347 1.212-1.767 1.71-.44.525-.754 1.088-.754 1.784 0 .695.313 1.258.754 1.782.42.499 1.03 1.049 1.767 1.711l1.737 1.564a.75.75 0 101.004-1.115l-1.697-1.527c-.788-.709-1.319-1.19-1.663-1.598-.33-.393-.402-.622-.402-.817 0-.196.072-.425.402-.818.344-.409.875-.889 1.663-1.598l1.697-1.527zM14.18 4.275a.75.75 0 01.532.918l-3.987 15a.75.75 0 11-1.45-.386l3.987-15a.75.75 0 01.918-.532zM15.443 10.498a.75.75 0 011.059-.055l1.737 1.563c.737.663 1.347 1.213 1.767 1.711.44.524.754 1.088.754 1.783 0 .695-.313 1.259-.754 1.783-.42.498-1.03 1.048-1.767 1.71l-1.737 1.565a.75.75 0 11-1.004-1.116l1.697-1.526c.788-.71 1.319-1.19 1.663-1.599.33-.392.402-.622.402-.817 0-.195-.072-.425-.402-.817-.344-.41-.875-.89-1.663-1.599l-1.697-1.527a.75.75 0 01-.055-1.059z"
            ></path>
        </svg>
    )
    if (icon === 'routes') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <path
                d="M29,10H24v2h5v6H22v2h3v2.142a4,4,0,1,0,2,0V20h2a2.0027,2.0027,0,0,0,2-2V12A2.0023,2.0023,0,0,0,29,10ZM28,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,28,26Z"/>
            <path
                d="M19,6H14V8h5v6H12v2h3v6.142a4,4,0,1,0,2,0V16h2a2.0023,2.0023,0,0,0,2-2V8A2.0023,2.0023,0,0,0,19,6ZM18,26a2,2,0,1,1-2-2A2.0027,2.0027,0,0,1,18,26Z"/>
            <path
                d="M9,2H3A2.002,2.002,0,0,0,1,4v6a2.002,2.002,0,0,0,2,2H5V22.142a4,4,0,1,0,2,0V12H9a2.002,2.002,0,0,0,2-2V4A2.002,2.002,0,0,0,9,2ZM8,26a2,2,0,1,1-2-2A2.0023,2.0023,0,0,1,8,26ZM3,10V4H9l.0015,6Z"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32"/>
        </svg>)
    if (icon === 'route') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>{"category"}</title>
            <path
                d="M27 22.141V18a2 2 0 0 0-2-2h-8v-4h2a2.002 2.002 0 0 0 2-2V4a2.002 2.002 0 0 0-2-2h-6a2.002 2.002 0 0 0-2 2v6a2.002 2.002 0 0 0 2 2h2v4H7a2 2 0 0 0-2 2v4.142a4 4 0 1 0 2 0V18h8v4.142a4 4 0 1 0 2 0V18h8v4.141a4 4 0 1 0 2 0ZM13 4h6l.001 6H13ZM8 26a2 2 0 1 1-2-2 2.002 2.002 0 0 1 2 2Zm10 0a2 2 0 1 1-2-2 2.003 2.003 0 0 1 2 2Zm8 2a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2Z"/>
            <path
                d="M0 0h32v32H0z"
                data-name="&lt;Transparent Rectangle&gt;"
                style={{
                    fill: "none",
                }}
            />
        </svg>
    )
    if (icon === 'rest') return (
        <svg className="top-icon" viewBox="0 0 32 32" width="32px" height="32px">
            <g className="layer">
                <title>Layer 1</title>
                <path
                    d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                    id="svg_1"/>
                <path
                    d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                    id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
            </g>
        </svg>
    )
    if (icon === 'beans') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>data--1</title>
            <rect x="15" y="6" width="13" height="2"/>
            <rect x="15" y="24" width="13" height="2"/>
            <rect x="4" y="15" width="13" height="2"/>
            <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z" transform="translate(0 0)"/>
            <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z" transform="translate(0 0)"/>
            <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect fill='none' width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'dependencies') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>application</title>
            <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                  transform="translate(0 0)"/>
            <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                  transform="translate(0 0)"/>
            <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                <rect fill='none' width="32" height="32"/>
            </g>
        </svg>
    )
    if (icon === 'error') return (
        <svg className="top-icon" width="36px" height="36px" viewBox="0 0 36 36" version="1.1"
             preserveAspectRatio="xMidYMid meet">
            <circle className="clr-i-outline clr-i-outline-path-1" cx="18" cy="26.06" r="1.33"/>
            <path className="clr-i-outline clr-i-outline-path-2"
                  d="M18,22.61a1,1,0,0,1-1-1v-12a1,1,0,1,1,2,0v12A1,1,0,0,1,18,22.61Z"/>
            <path className="clr-i-outline clr-i-outline-path-3"
                  d="M18,34A16,16,0,1,1,34,18,16,16,0,0,1,18,34ZM18,4A14,14,0,1,0,32,18,14,14,0,0,0,18,4Z"/>
            <rect x="0" y="0" width="36" height="36" fillOpacity="0"/>
        </svg>)
    if (icon === 'exception') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>misuse--alt</title>
            <polygon
                points="21.41 23 16 17.591 10.59 23 9 21.41 14.409 16 9 10.591 10.591 9 16 14.409 21.409 9 23 10.591 17.591 16 23 21.41 21.41 23"/>
            <path d="M16,4A12,12,0,1,1,4,16,12.0136,12.0136,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z"
                  transform="translate(0)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32"/>
        </svg>)
    if (icon === 'routeConfiguration') return (
        <svg className="top-icon" width="32" height="32" viewBox="0 0 32 32">
            <path
                d="M28.83 21.17L25 17.37l.67-.67a1 1 0 000-1.41l-6-6a1 1 0 00-1.41 0l-.79.79-6.76-6.79a1 1 0 00-1.41 0l-4 4-.12.15-4 6a1 1 0 00.12 1.26l3 3a1 1 0 001.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 000 1.41l2 2a1 1 0 00.71.3 1 1 0 00.52-.15l4.33-2.6 2.44 2.45a1 1 0 001.41 0l.67-.7 3.79 3.83a4 4 0 005.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 01-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 010 2.83z"></path>
            <path
                d="M0 0H32V32H0z"
                fill='none'
                data-name="&lt;Transparent Rectangle&gt;"
            ></path>
        </svg>)
    if (icon === 'yaml') return (
        <svg className="top-icon" x="0px" y="0px" width="32px" height="32px"
             viewBox="0 0 32 32">
            <style type="text/css">{".st0{fill:none;}"}</style>
            <title>document</title>
            <path
                d="M25.7,9.3l-7-7C18.5,2.1,18.3,2,18,2H8C6.9,2,6,2.9,6,4v24c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10C26,9.7,25.9,9.5,25.7,9.3  z M18,4.4l5.6,5.6H18V4.4z M24,28H8V4h8v6c0,1.1,0.9,2,2,2h6V28z"/>
            <rect x="10" y="22" width="12" height="2"/>
            <rect x="10" y="16" width="12" height="2"/>
            <rect className="st0" width="32" height="32"/>
        </svg>)
    if (icon === 'code') return (
        <svg className="top-icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
            <title>code</title>
            <polygon points="31 16 24 23 22.59 21.59 28.17 16 22.59 10.41 24 9 31 16"/>
            <polygon points="1 16 8 9 9.41 10.41 3.83 16 9.41 21.59 8 23 1 16"/>
            <rect x="5.91" y="15" width="20.17" height="2" transform="translate(-3.6 27.31) rotate(-75)"/>
            <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none' width="32"
                  height="32" transform="translate(0 32) rotate(-90)"/>
        </svg>)
    return <></>;
}


export class BeanIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <title>data--1</title>
                <rect x="15" y="6" width="13" height="2"/>
                <rect x="15" y="24" width="13" height="2"/>
                <rect x="4" y="15" width="13" height="2"/>
                <path d="M7,11a4,4,0,1,1,4-4A4,4,0,0,1,7,11ZM7,5A2,2,0,1,0,9,7,2,2,0,0,0,7,5Z"
                      transform="translate(0 0)"/>
                <path d="M7,29a4,4,0,1,1,4-4A4,4,0,0,1,7,29Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,7,23Z"
                      transform="translate(0 0)"/>
                <path d="M25,20a4,4,0,1,1,4-4A4,4,0,0,1,25,20Zm0-6a2,2,0,1,0,2,2A2,2,0,0,0,25,14Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect fill='none' width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class DependencyIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32" id="icon">
                <title>application</title>
                <path d="M16,18H6a2,2,0,0,1-2-2V6A2,2,0,0,1,6,4H16a2,2,0,0,1,2,2V16A2,2,0,0,1,16,18ZM6,6V16H16V6Z"
                      transform="translate(0 0)"/>
                <path d="M26,12v4H22V12h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V12a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M26,22v4H22V22h4m0-2H22a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <path d="M16,22v4H12V22h4m0-2H12a2,2,0,0,0-2,2v4a2,2,0,0,0,2,2h4a2,2,0,0,0,2-2V22a2,2,0,0,0-2-2Z"
                      transform="translate(0 0)"/>
                <g id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;">
                    <rect fill='none' width="32" height="32"/>
                </g>
            </svg>
        )
    }
}

export class RestIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <g className="layer">
                    <title>Layer 1</title>
                    <path
                        d="m23.50007,22l-0.5,0l0,-2l0.5,0a4.4975,4.4975 0 0 0 0.3564,-8.981l-0.8154,-0.0639l-0.0986,-0.812a6.9938,6.9938 0 0 0 -13.8838,0l-0.0991,0.812l-0.8155,0.0639a4.4975,4.4975 0 0 0 0.356,8.981l0.5,0l0,2l-0.5,0a6.4973,6.4973 0 0 1 -1.3,-12.8638a8.9943,8.9943 0 0 1 17.6006,0a6.4974,6.4974 0 0 1 -1.3006,12.8638z"
                        id="svg_1"/>
                    <path
                        d="m22.9724,22.26637l0,-2l-2.1011,0a4.9678,4.9678 0 0 0 -0.7319,-1.7529l1.49,-1.49l-1.414,-1.414l-1.49,1.49a4.9678,4.9678 0 0 0 -1.753,-0.732l0,-2.1011l-2,0l0,2.1011a4.9678,4.9678 0 0 0 -1.7529,0.7319l-1.49,-1.49l-1.414,1.414l1.49,1.49a4.9678,4.9678 0 0 0 -0.732,1.753l-2.1011,0l0,2l2.1011,0a4.9678,4.9678 0 0 0 0.7319,1.7529l-1.49,1.49l1.414,1.414l1.49,-1.49a4.9678,4.9678 0 0 0 1.753,0.732l0,2.1011l2,0l0,-2.1011a4.9678,4.9678 0 0 0 1.7529,-0.7319l1.49,1.49l1.414,-1.414l-1.49,-1.49a4.9678,4.9678 0 0 0 0.732,-1.753l2.1011,0zm-7,2a3,3 0 1 1 3,-3a3.0033,3.0033 0 0 1 -3,3z"
                        id="svg_2" transform="rotate(25 15.9724 21.2664)" xmlns="http://www.w3.org/2000/svg"/>
                </g>
            </svg>
        )
    }
}

export class ConceptIcon extends React.Component<any> {

    render() {
        return (
            <svg className="icon" width="32px" height="32px" viewBox="0 0 32 32">
                <title>concept</title>
                <path
                    d="M20.8851,19.4711a5.9609,5.9609,0,0,0,0-6.9422L23,10.4141l1.293,1.2929a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414l-4-4a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414L21.5859,9l-2.1148,2.1149a5.9609,5.9609,0,0,0-6.9422,0L10,8.5859V2H2v8H8.5859l2.529,2.5289a5.9609,5.9609,0,0,0,0,6.9422L9,21.5859,7.707,20.293a.9994.9994,0,0,0-1.414,0l-4,4a.9994.9994,0,0,0,0,1.414l4,4a.9995.9995,0,0,0,1.414,0l4-4a.9994.9994,0,0,0,0-1.414L10.4141,23l2.1148-2.1149a5.9609,5.9609,0,0,0,6.9422,0L22,23.4141V30h8V22H23.4141ZM25,4.4141,27.5859,7,25,9.5859,22.4141,7ZM7,27.5859,4.4141,25,7,22.4141,9.5859,25ZM8,8H4V4H8Zm4,8a4,4,0,1,1,4,4A4.0045,4.0045,0,0,1,12,16Zm12,8h4v4H24Z"/>
                <rect id="_Transparent_Rectangle_" data-name="&lt;Transparent Rectangle&gt;" fill='none'
                      width="32" height="32"/>
            </svg>
        )
    }
}

export function JKubeIcon(className?: string) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 59.799997 68.099998"
            className={className ? className + " icon" : "icon"}
        >
            <style id="style1" type="text/css">
                {".jkube-icon-outer{fill-rule:evenodd;clip-rule:evenodd;fill:#0a4e9b}"}
            </style>
            <g id="g8" transform="translate(-9.2 -8.3)">
                <path
                    id="path6"
                    d="M9.3 59.8c.9.8 2.5 1.5 3.5 2.1l21.6 12.5c1 .6 2.5 1.6 3.6 2v-6.3L14.8 56.6V29.8c-1.6-.4-4.2-2.7-5.6-2.9Z"
                    className="jkube-icon-outer"
                />
                <path
                    id="path7"
                    d="m69 59.8-.1-33c-1.5.5-3.9 2.6-5.5 3v26.9c-.8.8-4.9 2.9-6.1 3.6l-12.3 7c-5.1 3-4.8 2-4.8 4.9l.1 4.2z"
                    className="jkube-icon-outer"
                />
                <path
                    id="path8"
                    d="M15.9 28c1.9-.7 4.3-2.4 6-3.4l5.7-3.3c2.1-1.2 3.7-2.2 5.8-3.4 1.7-.9 4.1-2.6 5.7-3.2l14.3 8.2c2.4 1.4 4.7 2.7 7.2 4.1 2.1 1.2 1.6 1 3.7-.1 1-.6 2.7-1.4 3.4-2.1-.7-.7-28.3-16.5-28.5-16.5-.2 0-27.8 15.7-28.7 16.6Z"
                    className="jkube-icon-outer"
                />
            </g>
            <path
                id="path9"
                d="M30 9.5 8.6 21.8v24.7L30 58.8l21.4-12.3V21.8Zm7.4 29c0 1.8-.5 3.6-1.4 5.1-.9 1.6-2.2 2.8-3.8 3.7-1.6.9-3.3 1.4-5.2 1.4-1.9 0-3.6-.5-5.2-1.4-1.6-.9-2.9-2.2-3.8-3.7-.9-1.6-1.4-3.3-1.4-5.1h6.8c0 .9.3 1.7 1 2.4s1.5 1 2.5 1 1.8-.3 2.5-1 1-1.5 1-2.4V28.2H24v-6.8h13.3v17.1z"
                style={{
                    fill: "#0a4e9b",
                }}
            />
        </svg>
    )
}

export function AsyncApiIcon({ className = '' }) {
    return (
        <svg
            width='40'
            height='40'
            className={className || 'inline-block'}
            x='0'
            y='0'
            version='1.1'
            viewBox='0 0 277 276'
            xmlSpace='preserve'
        >
            <image
                width='277'
                height='276'
                x='0'
                y='0'
                href='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAARUAAAEUCAYAAAAFsqJHAAAABGdBTUEAALGPC/xhBQAAACBjSFJN AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAABmJLR0QA/wD/AP+gvaeTAAAA CXBIWXMAABYlAAAWJQFJUiTwAAAAB3RJTUUH5gcGCwkBMRK1zQAAOrNJREFUeNrtnXmcXGWZ73/P qeosvSfpTqdJlCwsIyCkAVESxQSJCIIEVJQRJHFFr3fEC8zn3rkzkujMHddrUGfGuQQIjKMsOoIb i0qCShAREiBhCQk0CaT39Frdna6u89w/3vVUV0Iv1X2qu5/vJ/lU16lTVe+pqvM7z/Y+L2GKwsyL ASwHcCyAJQAqACzW/wGgUv8XhHzTof/X6/v1AF4FsFNv30lEHXEPcryguAeQD5i5EsBaKBE5Td9W xj0uQTgKO6HEZhuAp4loW9wDyheTUlS0iCyHEpJL4KwPQZisdEAJzL0AHiGi+rgHNFomlagw8yoA V0OJSWXc4xGEcWQngC0A7ptsAlPwosLMywGsgxKTyrjHIwgxsA3AFiK6Pe6BDIeCFRVtldwIYFXc YxGEAqEeyj26qZCtl4ITFWZeB+CLUDETQRByswXAxkIUl4IRFWZeC+A7kKCrIIyELSgwcQniHgAz r2LmrQB+BhEUQRgp6wC8wsw3xj0QQ2yWik4Lb4IKwAqCMHbqAWyIO6Abi6XCzF8E8ApEUAQhnywG sIWZb9MV5bEwoZaKPtDbIBkdQRhv6hGT1TJhoqIDsbdBak0EYSLZAuBLEznXaEJEhZm/A+DaiToo QRAi1ANYPVEZonGNqTDzYp3ZuXYiDkYQhJwsBrCDma+diDcbN0tFx0+2QtLEglBIbCCijeP5BuMi Knq+zlZI/EQQCpFNRPSl8XrxvIsKM18NFRwSBKFw2Qbg0vEI4OZVVERQBGFSsRMqgNuRzxfNm6iI oAjCpGQn8iwseREVERRBmNTsRB6FZcyiooOyO2L9SARBGCtbiGh9Pl5oTHUqXtpYEITJzTpdpDpm Ri0qnqBUxv1pCIKQF67NR4HcqN0fZt4B6c4mCFOR1WNZMmRUlopuCLM87iMXBGFc+NlYWieM2FLR PWRvi/uoBUEYV7YR0erRPHFElopWr4JpWycIwrixipk3jOaJI7JUmHkLpFubIEwnRhxfGbaoiNsj CNOSegB1IymMG5b7I26PIExbFmOE/ZCGZamI2yMI05oOKGulfjg7v6GoSBm+IAgYQTZoOKLyCqR7 myAIwwzaHjWmooOzi+M+EkEQCoJhxVWPaqmIlSIIQhbr3mgtoSNaKmKlCIKQg2vfaIcjWipipQiC cASOGlvJaamIlSIIwlE4amzlSO6P1KQIgnAkVjHzqiM9OERUdPXsKgiCIByZIxoeuSyVDXGPVhCE gmctM1fmeiCXqLw77tEKglDwVAJYl+uBiKgw81pIgFYQhOFxSa6N2ZbK2rhHKQjCpGFVLhcoW1Qu Gd5rCYIgAMjhAllR0SmiyrhHKAjCpGKIIeJbKuviHp0gCJOOIS6QLyqnxT06QRAmJZGMcQDYgrfl cY9MEIRJSaR5U1LfLo97VELh0NzNObezN/20pnTUi1sKU4+IpWJEZVXcoxImhtYuRn1LBq2dIZq7 Q/QOMOpbQ6TSjJ7DQM8AAwEQAkBAYIL3nwDzdwAwgKqyAKUzgZKZhPklhJrSAEvnBqgpCbCsUoRn mrCcmStNx30jKhJPmYK0doZ4Yf8gXm3JYH9ziFdbM0j1s7I4iKwwMMEKSEAAs+6JkWWwEBgMJSwI ARDQ2sNoTQEhsRacjBUgJmDpXEJNcYBT5ydwXCXhtOpRrbQrFD7LAWwDzG+HuR2STp709PYzduxJ 48VXB/H8/kG0dYUISWtDACUkxtKAZ30EZh9CqLfDWCOUw1rRlozdjwAeYtXksGwIYBBOmx/gtOoA y6vUf2FK8CUi2gQAJN3yJzdtHSG27zyMF18dxJ79g0MEw5347qSHvVUiQgGs+GQLB3KIBYgQ+oKS JSwg6MfdfqF5buC2MwE1JYTlVQHeVRvgnQsScX+cwujZQkTrASUqqwBsjXtEwvDp62c8/Fg/9tSn 8WL9oDppAW1dkHNpfGshyBINIyJ6/8g+3rZQCwGDnLWRbYUcUVScuHCWsGRbQCBgfkmAuqoAF7wp QN1csWAmGTuJqA5QMZXlcY9GGB4vvZzGrx/uw0uvpO3JSlocyMREQ3WSEvRGhjr5Q28fAwEIGRQQ QgaI3TZoV8XEWEBs0z9EQMisX1q/GXvP04JDgelXqvYM9F8causoazjNqRAP9DLuP5DBghLC+uMT OH1egAWzJeA7Cag0fxAzbwLwxbhHJOSmr5/x5yf68fhTh/FaQyaSeUGOq71zfzwXZogrBOv6RPdx guDiJjrmkhUrURYNhro6vtsEF0tR+5GzVOBZRIGzYnwXyxzrBYsS+ORxCdSKuBQ6c4iog5j5Z5DZ yQVHfz/jkd/3Ydsf+tDXz05IApWDicZIoid5JJ6CI7ksBCa2J2/285h8ceBoEDeIxmfCHKKVM3gL 99wjukKAJ2LRDNWFIi6FzhIiqk9Csj4Fxx9+34cHH0yht59tbIP0HxwyiAjMym0BAL0XiEmlgwlA oNwVv2DNpoT13wDArAQjAiv3JACAkMHaPQqMFcTGp1JCZkZBpPbTQx6SkoZxpeBS1xyqsRLIWkzG ZQM7VwkM/Pr1DH51MMSFCwN86rgEameJuBQYiwGIqBQSL780gDt/1I32jow9r8i4EQyYs43BCIjs CQrAnoRkLIwQIBskceeqe42suItFF6nowEyo35y0QFEw9D3tM0M9LrNZx1isGgX69a1S6ieGAGth MS/JevwBSAmPiQsFjF+/HuJXB0N8alkCHzk2QFlSxKVAqABUoLYy7pFMd9oPZXDPD7uw76UBcOBO NgqcVaAEAFAnpXc598SEmW1w1QVBWf8jEBlTQZ3ATmTsi7tnaUso0CczSFsi+gQHOUvJCYaxmsi9 Wpbl4bZ54maL6ZRVZDLPvgjCbNOWDUDYvC+DXzaE+PTSBN5/jGSLCoA5gBKVxXGPZDrz6MO9+O39 KfT3herkYi0aAbS1wFmWhPGFtAsUQsVF9MlOYHBIEQPExF5D5iEWi3FDQi0+lCBrTFC23jDrYSkx CEPWrhZFDJzQFwxjZgX6hYznFKg9jCViM1Yh2+CwHWbgRFDrmR1vYy/w1d2DeLI9wKeXiUtUCCTH /hLCaGhvy+C/7ujEy3sGbLDVaAoFDIQqkEra5VCC4F/2/RgHrCVj/zZoK4L1CRzCf1wJkDF4iAhh Rpk9QaDcGWUtkb5FJA1trSd2b4WMtrBM9Ea/vo2NWP/GG4OXbgZg09dGpJij44dJj+uxMBF+dTDE Ux2MTy1J4CKxWuJiMSCiEgv1Lx7Gf/5bB/r69EnrBSv9Ex6s4xMmNqGDqjbgqqOyRNrpCMkTIGhB IePxaBdGiYd5PpELfTCp51WVu3R0VUWg1EsPrKlLndGpAUbPgH5dY9qY/cz7GfctUKJhLRuCEs3A ZK9dABmAeuPAHKN6HRsMBhCRTXOgIaGxl/HV5wbxUk8Cn1oqsZa4EFGZYLbe141tv+gGJ5SEGMvC eDlEAGf8q7qzTGwIJVeAFu6qbu0Z4wPZE1y9/tzyAIsWJDBvTgJvWhCgeGaANy1IoHgmoXiE7kNL N6OlK0TPAKOlR/39cluIVw6F6EmbTJX26LI9uch9ty/gu01kPxvvk3DYGI879h/vz2BbS4gfnJEU dygGRFQmiP5exn23tuOFHYfVhgzbVClpa4J1ANXGU00EVv9ptqn9WYdXdIREmxxEzqpgMIpnBVhY m8BpJ83AotoEFi1Ijlg4jkZ1GaG6LPecnVfaQjT3hHj81QxeOZTBvkMcOTZrWen9TbqcABsj8mMs Rx+1ylCFUOGYxj7GNU8O4ssnJ3GGtGCYUIg5ct0TxoGO1gzu/m4bGg4MMghkC9Hgz8mhyPwbW2wG uLk3fjVqrqI1qL/nzUvglJNn4NSTZuD4JUVxH76luYexqzGDx/YP4plG1cMFAQ2tpvXmLw2ZHW0K 7szn4lXe2mpiU3SnP9/rTkjgo2+SyYoTwEYi2iCiMs50tGbwH//cgo62DBjEJigLAGGgStPUSeBV uyKrVN0rvbdVs4hWyc4qDnDOu2Zj2dIiHL+scITkaPxu7yAeO5DBY69lIiX9Q449iIqF+ZyONIua s54LAj69NIFPLxFhGWc2EtEGcX/GkY6WDH74z83obM3o4KiJd+gMC5NqbsSq0IvZBWr9tG+kRsUE OHXgZNmyIpz/vhIsmyRC4vOe45J4z3FJNPUwnm3K4D+fTaMxleMaZ9LlrD6jMFAxlyCSFVOYgHNo p1krYbn5ZSVcnxFhGXdEVMaJzpYMfvR/mtHVEjKROh+CgClk4oCY9I+eyehDaMQGSnDgCk/9UnUQ Y9asAO9cVYxz3l2MWVNgHkxNKaGmNInzliXxm32DSlx6h2Z6TJUthbBZLfWxuBCuquQ1xqAWZVa6 tPnlDAARlvFGRGUc6GzJ4Ef/1Iyu1kGQjTwCzOCAmEy5Obx6eQ5Z1YaYk4N1NkSnYTkkzC4NsGLV bLxrdcmUEJNcrFmWxJplSfzm5UH88Nk0mnpN+Fph5YNdNwYKIo+4NDkpwQlD0laNEhYCxBUaR0RU 8kx/KsSPv9qEzhZdLRKw9V+MtpAuD2VkCQfrbI4JyIYuzXpS3Uxc9KEyzJk3PU6GNUuTWLNUi8uu QTT0htEqHpMp8utszPQDbanYKmNSbqOpCbr55QxqZwEX1U6Pz3KiEVHJM/f/Wxs6mwdVTRoRmImJ mBghOSuE7JQXbbrb+lF/LgwlCOVzA3xwXSWWnDAj7kOLhTVLkzh7UQL37hnEf+xKw58gGeqK4CCw JS3gIGc1ixKc0BXnfWdPBieUBjihbGpafHEi9cx5ZPs9Hdj3RB/IzMkJGeCQONQlr6oKjAlMZP4O oZLFHBIxEOgADAE4e3UxvvD31dNWUAylMwhXnlKEOy6ejQXFpAvjlPtDrAMmXhEhMetbHdDVsRdi VnMRQ6AnDdzwzCC6ByX5mW9EVPLEgd39eOzuTlWAxm4SXwAgYFWVon7kISEkJhATh2p7SCZTCoSM ynkJrL9+Hi74SDlmFcuV1FBTQrjj4lm49IRERDCsiIT6P0f/QwsJecKDUBXI3fDMYNyHNeUQUckD nc2DeOj7re7HDWgrBW5ujGqbppqtISRi5RWpilgmc4U99oQZWHdDFRafOL2tk6PxuboZuKauCKVJ ilosxoIJjdDwUIEJ2VosxMBTbYw792fiPqQphYhKHnj8rg50NQ06CyXUVoquKyRWk+aIWU3p0WJC esagegx4+5pSrPufVaiskgDiG3HZCUl8a/VM6w45t8dZLQiRU1jsvCJtvWx+OYOGfnGD8oWIyhh5 7uEePLe1x8zPV1dCLRIAQCHbx4jBHBITM8EKCwAGzllbhvf+dUXchzOpWDaHlLDMpojbA19Awtwx FiNCAQPdA8BXdosblC9EVMbI4z9ut4FVGDExV83QCx5CBWRJB2T9H/85l5bjnEvL4z6USUlNCeFb 585EbQlZsQh8UYGJtXBEdPx9AgA72hhPtYu1kg9EVMbA8w93o7spnUM8YGMpQ66egOpjol2fd11W hneJoIyJmhLCN1fPRI11hZR1aDI9ftzFiAs8N4h0/Ouru8RayQciKqOkq3kQf/5RuxUJ45+rvzma 3oR3CycsZ72vDO+8TFyefFBTolyhMhO8PUo8JVd2KGCgsZdx16sStB0rIiqj5OAzfehuTNtm8ebq 6FsrQ+smXHylYl4S7/l4ZdyHMaWoKSFc//aiqOVoLBYvrYyQoy6SF+TdvFdEZayIqIySP//nIWuB mF5KZFo06h+uSStHXKAQqKxO4Iob58d9CFOSFQsTuOzEpHV9AuPieHGUwEstZ8dgUmnGr14PxziK 6Y2Iyih48bfdSDUNehPbOGqRQP947RRk3w0CVn6oAhXVMkNivLimrgjLKkkvhqYrajlHfEsHcKNx F+DXr4m1MhZEVEbBi7/pgipoy8r2mO6PJo1sSvVNJ9aQcfKqEpy8qjTuQ5jyXFM3IxLbQg6LxXd9 As892nkoxI5DkgkaLSIqI6S7KY2GZ/q8H6wnLDrbE5CXWfCvjgBWXF4Z9yFMC06dH+CyE5OuCC6M xreQLSxhNKj7+yaxVkaLiMoIaXi6LxKQBeDiKN4EN/KFBWr7yatKUT5f3J6J4mOnFKG0aGjRW65A LbSLBC1C9x8QURktIiojZM9DncpHp6gFgmyLJWsCGwF4x0cq4x7+tKJ0BilrRWd2closQypxleCk BoAdbRKwHQ0iKiNgoCdE4zN9AKKT08Bm7XG25rZZqMvEVU4SKyUWzluaHGKRuLlB2mLJmt1sLhAv dUlcZTSIqIyAtn2HnYujGz/q1gbOYiG3HSGryYIATnpPWdzDn5bUlBBOnR94LRI4q5w/92xmYsaj DWKpjAYRlRHQ+HRvtMjNFxPfnIbbTgDK5yex8JRZcQ9/2nL2omRkvo83wTMrWKv+m/32doqojAYR lRHQtrffzUb2+3iEDLNKacJbhtQE/RaJoMTKmmWJiOvj161E5gXZQK7633OY0dgrLtBIEVEZAanG tFqW1LpA0QmEZBszaTNbp4cWvnV23EOf1pTMIDXZ0I+b+DGVrFJ9M3NZWSsiKiNFRGUEtL+k+8/C iYezWtjOeLVzTfT9qsXSxS1uTq0JXDsKvy1CxJ3Nak/JQGNKXKCRIumIYTLQk/HqUmCLVMzyGgCB iOxyEW5RGqBq2cy4hz/tqSnVDbP1Ko9m+oTrwq/2M18th4yACKl03COffIioDJOBntAF+cwiPYGV GbBer0cv6QNkAASM8prJtxzpVKSmJLDd+OzyZHpdILNsB/SfxjZhMJpS4v6MFBGVYdLTmNa1J0pQ WC9NGrL+iQZklyWFXpaTAJRJbUpBUG0tFYNnboZqxSXSi7u7JWZhLhHCCJBf/AggOEMlYAaHbpFw sxoe7Dp6ahvJb7IgiEwstJFEJyyezQmYRcc8C0YYPiIqw6RsQRKnrqt2sRRAT0nW97VHZLfpm5IF 4v4UAvNLCVfUFan4uRYM/ztk871m3daUyrpLI4WYWbRYEIR8sJGINkhKWRCEvCKiIghCXhFREQQh r4ioCIKQV0RUBEHIKyIqgiDkFREVQRDyiojKODPQE6oS/wKnX/qGCHlCRGWceeJ7jXjw2ldxaG9/ 3EM5Ii8+2Ydvfe4gHrm3O+6hCFMAEZVxZN/9Hdj3YAdSjWn84lOvYOftrXEPaQidLRn85ocdIGb8 4b+6+OZ/aOGOVlmeQhg9IirjRKpxAE98r9Hricp4+rYW/PzT9QXlDv32hx3c1ZJhhMREoKb9A3TH P7fg6T/2xj00YZIiojJOPPSFegz2hJEG2ADQvrcfD3xpP/Y+2Bn3EPHHn3bhpSd7iZiJwIQQjJDR 1ZrBzze346EfyxoVwsgRURkHnr21Gb2NA9E1lb2Wk6nGAfzxaw14/F+aYhtjZ8sg/nhPJ5uORLpN JhETk26D+fgD3fTd6xsh7pAwEkRU8kzTjhR23dJsF2tXXfbZNcf2lvd4/qftuPuKfeieYHeoPxXi zq80axFhEKuuLxS6fq3GwupsyeB71zfx4w+l4v5ohUmCiEoeSTUM4M//+JqyUOBOUnOCBt6KhUZg ehvT+Mlf78Pun7ZP2Dgf+0knOpvS1i0jDsk0kwoAcKhbjtixMz30ow78/JZ2sVqEN0REJY/suKkB vQ0DbhlUmHiK6sBvm2STW8DddCR74l+b8fuvN4y71bJ7Ww+e/GWXFjj21xJmtQoAU0BQIsPEgV05 AHj6D7244+utqH/hcNwftVDAiKjkid2bm/D61k7dx1YJiFpf2V93GW45CPtM7RqFjH0PdOL+/7Ef bfvGp6als3kQ2249FFk03lkrTGDVVN6tf8MEE2NhMFjFYu74eiseuU9qWoTciKjkgVTDAJ67uVE1 SQ7ZujocujWCIkuj6lUNSf83C70T1IJl932mHjvuaMv7OH/y5UYMpEK7eiJxloumhUVZLsTE4ABM euxk+7yGxL+/txv/fmOLuEPCEERUxki6O4NHrtkbueob18ItWqVXvSNyVkJkhUOOBnFDYMeWFtz7 mfq8uUOP39WO7ua0FRLjkpn1b7xAMpk4ikozG9FTFgu00CAEN+0fwB3faMXOR6WmRXCIqIyRorIE Fl801xa4EQAeZBdLiSwK7iwSwIkJvCWEiNWJTgAO7e3Hr687gJfyUNOy9KwSlFclrXgoASEX/wn9 DBUYobZYYIXRio0VHQY6WjL881s68OCPu2T+kABAGl/njd6GAWy7Zi9SBwd06kRFY233dnU6etvI dXUnsp34GQACvQ3u9uQPzcHpV1VhRunorwNdzYP4013teH5rSpXOmPHYzvLqfggzLvf+IG1b2bXO iUEg/TgjAFVWJ/HxG+ahsioR99chxMNGItogopJHehsGsPvmRtT/8pCKRBDplQv1icuqcIWNwADg wCwRYU9eJyxmKatA3ZYsKMKF334Tysa47MeOX3ThT3d3oD8VWlEzC/bZZSv0UqDMxByYsTEp0SGG WvBPLfVHaqkcM/bzr6jAO9aUxP11CBOPiMp48dKPW7B7cyPSPWF0PaBAhShM4IXZs1igLQOQO9Gh H9cntbEm3v75+TjlsjljGmNX8yB+8uVGdDYPOmtJv76xVKwYZo0HxJ6l5awxdmKD095ZjFUfKBOr ZXohojKe9DYMYNvn9qKnIa1OWr1Yu295sLeQFWe5R86CIDDYsybU7fHnV6DuqnljtloeufUQnvpF lxUPZLllZnwgQkjEDCZkCUhu8QEqq5O45BOVWHzijLi/DmFiEFGZCHbf3IjnNje5kw3IimNEYydW dLRF41wP9xyzb1ntDJxzQw1qTyse0xife7gHf7qnA53Ng07gAD3HwBOMyHid26THpGMs2WIEvPuS Mqz6QFncX4Uw/oioTBT1vzyE3ZubkGoYiLg3RxYYRCwWFzyliDUQAqCAUHfVPJz+8XljGmNX8yAe +n4r9u/qd+Ozy4NGrBf1iwlAIYjJBm6zx6+tKjX5CRVVCay7oUrcoamNiMpEkmoYwBNfOYDmp3qG CokJ6AZDA7rKavGCvaCsrIx6jZKaIrz/24tQVjM2d+hPd3Xgsbs7lDgEnisGM6ZoNsu6RiA9xZmY tcUCQMeRiBEwVVQlseoDpVi+cmyWlVCwiKjEwXObG7F7c7MN2Fp3x3OP7AnNyhKJBk5990OnX/Rt SW0RTr9qHk54b/mYxtjVPIh7vtyIjpZoENeOJVADCnUqWQshq/GpDJEL3DKxqdgJ1HTot68pxeoP lGFWsSx+PsUQUYmLVMMAtn5uH3qb0lAnp7ZEjDWQIytkH7fZGfKsBAYpawEg4OTLKnFGHmpaHrun A7u3pjzrRLteAYxFpYv3mTjQMRVfSIwb5MWHjJCWVyXwCXGHphoiKnGS7s5gx6aDqP91ezQegaxM kF/Pwr5l47lCZpv3OqW1M/D+by5CWU1yTON86pddeOyeDvSn2I4FRGrmIYDQz2DZor8s4QOUexTY Il4tmozVl5Rh1cUSxJ0iiKgUAnvubMGuzc1I92SidR9wV3XOEgzAsxhAkYI6Y+WYWpi6K+fijKvG HsS9Z0MTOlsGoYO0keCtExZiJpU7V+PGkBoYm0on9TohCMtXzMZqqWmZCoioFAqphgFs/fw+pBrT 0UI5uII3e2LadDNFMjPWRfEeN/ePX1OO06+aN2arZfvdHfjT3Z2RDJXKQKn7IQesq26ZVdDWzyDZ lLM5HusW6ZqWtesrsURqWiYzIiqFxq7NTXjulmaE4Byp52jAlNkFcyNzhQAvHa3dFJ0dWnVdDWpP mz2mMe7e1oPH7upEZ+tgxPIwGSE/Q6Q6spDuo6AeN4Fev3guVEMEE2HVJWVYfXFp3F+FMDpEVAqR 1x/pxFObGpBqHPDiE15mKNDzn4lhJynqRgUIbKdKG3eBH9wNCKfnyR168F/acOC5/kjsJGRiCpj8 NHJW8NkGc1UMxswlgpu6QEDFvAQ+cb1MTJyEiKgUKqbXbZOpaYEfjI3GV5gA8upeQl3bAl3aH5kW wAASQEnNDFychyDu9rs78Kd7OqOFeW6cDCjhUNsDRqDiLW4WtBIXEMgIohnrzJIAF3ykHHUrxmZZ CROKiEqhs/uWZuza3OQmJXoTC/06liGPZ4kJ9N+m3QGDMKMswNnXVOPENWOsaWkZxN03NqGzddC5 ZIDnriljhaEsGNs2IXAWi/qbswrs1L5nrynB6oulpmWSIKIyGUg1DODh//YyepvS1rVhIlWI5gU6 Yapv4awFa0HohyMZG+0WvfXSSpx+1TzMLBl9TcvhVIitWw5h97ZUzhiQEQrbNsHEWCIVwtC1NrDH Yep3KqoS+KS4Q5MBEZXJQrong6e+04BXft2ePYlviEXip2xz1rtQVraICKULinDxN/JQ0/KrLmy/ uxP9vezVrWDInCYrLFZgCNZqIVfL4lcTMwGrPyBB3AJHRGWy8cqv2vHUpgYMpDK6rN9P2ULdN7Ur nnCYKQCRiYkm5mKbRAFnXjkPZ1w5d0xj7GwexN0bm9DZrOtudEm/rcANXKMnJXTKLbLjBSJj8lPX IOCv6mbhwo+Uo3KeWC0FiIjKZES5Q68g1ZiOXMWB7EAphrSu9LfZWAwQcTkWryjFis9W5yGI24nt P+n0Jj3qOpaAyRTPOYvFZIZ818mbQ5Q1gbGiKoELLy/HW+pmxf11CFFEVCYzu25pxrObm7zYCeyE QzBsfYofPI3M38mqMfHbSJbqmpZjTh1b5mXvn3ux9Y52dDRnQIFKObNuP5nd3iGMNH3K7oKnU9J+ fxcA54o7VGiIqEx2Xvt9F3bc1IAebbVQdgFcZBa012A7UO6Ps26GNmICAWdcOQ9n5sEdeuBf23Dg ucNOQCjQyw24GczKVWK9fpkL5voCaLvReenninkJfPK6uRLELQxEVKYCqYYBPLmpAa//sTtHi0rY 2pZIjMUL4AJZ1oqfEmagrLYIF389DzUt93Ri+z2dUcHzu8ZB1apYC8UvkNOZLspKN5us0sySABdc Xo7TpaYlbkRUphLP3tKMXbc2u5OOAUoQQtPgCfBSzn6sAlltFBS+hTCjLIEV11ThxPPGXtNy58Zm dDZn2MZMkJ1OdjO1TYEciEkHdomMGOXIYtWtmI0LLy+Xmpb4EFGZaqQaBvC7L7yCnsa0y6Ag2rUt 0mLBzBbO3hZkPU93pjvhveVY+dnqMde0PHx7O3Y/kooEiHX2ilWbSo2uzFWFczru4sVkbH8ZL1ZU WZXAJ6+fK9mheBBRmYoM9GTw7K3NePGuNi+G4k7AaONqz6rJrtYF3ExobzJgaW0RLvnawjG7Q7u2 9eDhLR3o72XbPQ7wLBBVxkK25J+YfBGKtFEIoiLJBKy+qBTnShB3ohFRmcq8/Kt2PPndRgz0ZKLu jS8gXpe5IbUuR6jENdvP/NhcvG2sQdyWQdy1oRmdrRkjXK5lQqRAznTpNy0U9DrygRufa83pxvtX dTPx/sulpmUCEVGZ6qQaBvDbv6lHz8EBl26Gq3SN9mKJNtIeugyH97hOYy85uwQr81DT8ug9pqbF SyFnZ338LFFWDUv2tAAmV41baWpals+M++uYDoioTBeevaUZz9zaoqtbPQGB5wIBEYtGWTBer5Qc c3oYQHltEc7+TBWWnj22ZU73PtGH393ejs6WTCSzw7oNpYmn+MISWWvIjM2zqkwqPQyBcz8g7tAE IKIynWjekcJj//Q6eprSdqEyIxRmciG8KttIsyc7wc81UzKZIrP/266ch7d9bM6YxtjZMoiHb+/A 3r/02TYNzLprv+siZ+cM+esThTp2FO0fE63ZqahK4FPXSRB3HBFRmW6kGgbw5HcbceCP3QCGNtn2 FwCzKyT66w1BbTMzpLPrRcoW5CeI+6ipaQlIBWxtL14dYwn8BcxM9scTEz/AnGVZzSoNsPqiUqx4 j6w9NA6IqExXnrm1Gc/e0uy6yAHRVQkRjbGENtbhu0luWRG/C93M0gTO/NgcnLq2ckxj7DQ1La2Z HP1ZouKSLRwmpuJbXdkuXN2KYlx4ufRpyTMiKtOZVGMav/nvamKimS8U+m0SyBXORQXHc4myBMgv qDvxvHKs/GzVmGtaHr2nE395oCdapg/T/9YU0PmLliGaYobOcsEdm5pQCZTPS+JT180Rdyh/iKhM dwZ6Mnjm1ma8cM8htcEGaP3gLLuVESl6skYzNdnrQDNKa4qwNh81LY+k8Lvb23G4l10DKt3+1gZt dbtK7S6Rm5IATyizJirq11p9UYkEcfODiIqgePn+Djxzawt6Gga8ArKoSGR3aQOGbjOuhu96gAgf +NoxWPjWsc3LUe5Qi1p7CMTKUmIvaOs1dIJfLZxVc0NDrRYQcPZ5xbjw8rFNQxCUqIzeNhWmDEsv qMSa7y1Gae0Mcx7a/wFgW/QTMxDqltbM4FDdEgAKAWL1HLMPMXDie8rGLCgAUFGdxGe/X4uVH6oA ERNYFfCbhVfdffW+AbOq99fjVmOHfZzNGAFUzk1gxbljS4kLDhEVAQBQsqAIa+85Hqeur3YnqBET QOds1Q+G7K0WmNDmkdwPKmSU1ySx8rNVeR3nyg+X46P/MB+VVQkyokAMUKi6PRkxVCaIExkCgcgd T8Ib/7kXl0rrhDwioiJEOPUT1Vjz3cUoXVCkOiOEWmAAa6FYsTEnLpwFYAQJDFz89UVjCtQeiTef PBMfvbEax58521pPtoFCyHoMTvjAUGMOnTUDBigDrL64FHUrpWVCPhFREYZQU1eC825ajKXvq4wK BtQkYQD25Azg3Auz3GAAwplXzR1zgPZoVFQncen1VVj5wQrVdMUIHzw3jI1bpsYXeOMFM+ZUJ7Dq EgnQ5hsRFSEnpbVFWPF3x+C0T1TDVLMYS8Be6aHiFG5xIfWDqj111phXQRwuKz9cjmu+v4AqqpJA qMtnmJhCBpn7oZ4EbcqCQ2D27AAf/9uJGeN0Q0RFOCqnrq/G2ruPR2lNEShk5RJ57hAh6hqV1iRx zvULJnSMFdVJrP96Dd52YSlRaGuEbRCXEBK02CBU4121tkziKOOEiIrwhpTWFuH9ty3FWz48V7tC Lm5irRcAAQNnfHweyhYUTfgYZ5YEOPfqSlzw+bmomJfQcSCOCmCoAsnL3zkbZ50v2Z7xQkRFGBYz ShM4828WYMX/qkXpghlaSLSYQAVv6z4+D8edXxHrON/67hJccWM1KqqSLjOllzskMFVWJfCuS6Ue ZTwRURFGxLILKvHe7x6LuSfMsi4PWE0mXL4uv+nj0VJRncQ136/Fyg9W2MBsAKYAwMf+dxUqqsXt GU9EVIQRU7qgCBfdshSnrq8CQsbM0gDnb3pz3MMawsoPl+OKL89HZVURwIyVl5Whonr8MlKCQsr0 hTHRuKMXvU1pLH1fvG7P0ehsGcSuR3qx8kPi9owzMvdHEIS8InN/BEHIPyIqgiDkFREVQRDyioiK IAh5RURFEIS8IqIiCEJeEVERBCGviKgIgpBXpGZ5mPRsb8PeDz5q17qxC4OzWegK0e3QC2ytmIu3 3HVW3MOf9rz+bD9+8veNAPzVANxaQa4zP3kLqQHHnVWMS2+QvisjQSyVYcOu+5lpYaiLkYnY9hZB qHuMEGwnNKEw8HvawrS+BBCQ18dWt3GA7hI3WxYbGzEiKsNEL22jfpDEoICUuLilzvXyxNFm0GFX Ou6hCwAOpzKuLabXSR+2xy283rtaWPRqAcLIEPdnmBQtKnY/MAYoCKH1BcwAJQhs7GZiQK0fjkzX YNxDFwB0N2V0mwZCQFCLpIV6bSAo65JJfWehWY6ECOUyq3nEiKUyTBLlRdZaCQh2qQci0m6P6TKm r3b6UjjwWq8ISwHQ1ZR27S91Q2x4awPBa+jkWzGzxmE1gKmOfGLDJFFRhERZUv3wvGUgwKH6BeZY osIITO/urriHP+1p2zcQ6bTv99gNYBYgMw2d3H7S0GnkiKiMgBlvLo5YKybGQmYxLWNNEyLCIqIS Pwef6VNB2CzhtxZK5EJhVz9E+Xxxf0aKiMoImHVSuYurhAyEynYm/d8EbZU/DusWdT7YGPfQpzUH n+kfaqH4axbBLBdN1iUyLlL1khlxD3/SIaIyAmafUmHXwDG/Uq/kwcVUzD76B9u9/ZDEVWLkxYe6 PDFht5ZyaDrts1vBELB9dxedMivuoU9KRFRGQMnKKp2C1Fc6kyqAH6T1grUAjCXTdvdrcQ9/2tL4 dF8kTUxgBDrAbhdGY1evYiyY6iUTv9TIVEBEZQTMOrkSyYoildkBlICQ/hBNIZzZnnW/4wFxgeJg z0Pd6G4a1CsTsrVC3NIdzt2BZ72AgWXvKI57+JMSEZURUn7hMRE3x1Zlwsv+mO2ea9SzvQ09j7XF Pfxpx5O3t9lFxGxMJXRWS2QRdy9wS8xY+FZxf0aDiMoIqfyIXorCVl6yVxTnC4oO5JorIxgN394T 9/CnFXse7EKqMe1K8nU8hbzvzgVwo6sZipUyekRURsjMkyt1IZzn3sDLItjUMrn7uoS/Z3sbmm9+ Je5DmBYc7gmx4/ZDnojAxlMAv8ANLkYG9z3+1ZrSuA9h0iKiMkISFUWo/Oix1lJBqKtnTRUt1HY2 V0KdFQKrmYWN394jmaAJ4LmftiPVMJDTCsm2UGwQV4tP2fwElpwtay2PFhGVUVB+4TEw6R0KsoTF xlhcutK5RSEyXWm8+sWdcR/ClObQ3n7svK0tMivZTyeTmUkesp40qOMsujhu4amz4z6ESY2Iyigo XlGNkhXVQMbFUgDn+riZy3BzhOCujJ0PNoobNE70NKax9e8ODgm6ms/fn9tjvo+APFcIjDOvnBP3 YUxqRFRGSfUNJ4ECP4bCNiDo5v2wF1OJ1rG8fuNu9En5ft559J8a0NOY9oLo8CxGv62Bqzcy6eUA wIlrylBWI6X5Y0FEZZQUr6xG8Yoq3YQpK6YC9wNW92FvbXYIjJc/8QQGXuuL+1CmDE/f2ormHb3W 5TSBVzb9U7KExcZW2MVWzrhqbtyHMekRURkD1TecrJoyAQA40tQnKjDsCQvbH316fy9e+uB2EZY8 8MytLXj21hbYZlna/QlgihOdeERqUswkwpBxymWVKFsgVspYEVEZA8UrqzHnMye4Hya5OhXjApnJ asa3N+EWsz19QIRlrDxzSwue3dwChGzbF9g5PaYMnxCxSmxpPtT98poinPLByrgPZUogojJGqm44 CYmKIiDQpjR5xVRApLOYa+wUbWUowjJ6ntzUiF2bW6x1wqYvMDvL0Z8waGMpkV7DQN3Vc1EqVkpe EFEZI4mKItR+9yydCWLTi9AFa3WqEsiaycxRKya9vxcvnPd7aZMwTNLdGTz8+Vew58422/vELzYM vKB5QGStFVuuH+qmTACOP78Mx7+vPO5DmjKIqOSBsguPQeUVi73JhIhmgWzTpqwZzLpxtunFEnYN 4OX1f5Fy/jcg1TCAB6/ai5YnU167AicW2Wl8znY9Q/WZMzPKFhShbr0swZFPRFTyxPx/rEPRscW2 TsXWq/jC4vda8a+ovsvEIRq/9SJe+vBjOHxA3KFs9vy4FQ99bC96Dw5oKwRWyEnPuSIvAGsrZpkR gL2iRPXjf9sXqlG6QFoc5BMRlTyRqCjCwi0rEFQkvfWB1K1NL/vCos11zrZsdOOnnj+2Yu+HHpM+ LJregwN45LP78PT/PYh0VyYyTUL9iL2sjv8Z223Q7Q9g4y2nrZ+HN79L5vjkGxGVPDLrlDmo+epy l0L2082Ai63YZ7jCOfKuuOb5A/tT2H/tDry8/i84PE2DuOnuDJ7/9yb89q/3oPUvKd1MyQt6w9Wh mEBswN5nbQoQQ79OBXjL5XNw2ieq4j68KYmEu/NMxRVLkD7Qi9Zv7obqLcYgnc9kpkgzJ9YzmUHa 7ydfbtR9BtD5UCM6HmrC3A8vQu31J2DmoukxN2X/zw/huf/XiN6DabUkKQBi9ZkoV1F9igF5ay5F 0J+weUgL95wTZuNUEZRxQ0RlHKj625MBQAmLMkHAoZYR7wQgVo49h0AQmEiLCyhC7aUEBsChu1/D obtfw9yPLELtdVNXXFr/0o0XftCI1id77LrUBJuHB6xQuL+NHjO7Zyjd0WLNStRLa4vw7q8txIwy MdLHC2KWdR3Hi9Zv7kbrN3bDLfqtF3Bn0ldefXIErh+/eRyBew6HAAcRRwpMhHmXL5wy4pLuHsSB nx/Cvh82qyCs/ayAEAQKdK2sEQ9XCaQ/RrIfp+0OTN5i7CAUHzMD7/nXY1FSK4HZcWIjEW0QURln Wr+xG63f1MICwM8B+SeOLeQPAoQhuxPFFxevlbYpcmEGylbMw9wPL0Tl+xYgWT65jM+2J7rR+HAH Dvy8DQPdGWtyuM9ICwO5+ZruM4kKjRJbOAE3r0OE4toZOPcHi0VQxhcRlYliiMUCVYXFTPbEiJxE 7J1M8B63zzcnml+7q06oyvNr1P/31RSswBx6ogttT3TjtXvb0NswkHXM+m9oQQj8z4A9sfAsO2PJ eOLMBBuTqjxhNlb/YAmKxOUZb0RUJpL2f9+Dpr/f6YQh0D6/LyjwhQTOutFWinGZsnJKEfGB2Z+A srPnYc7581F8cjnK3hFfj5C+1w/j0J+7cOiJLjQ93IF0d0aPlYEgiFodUFlfCnx30H0W1s1hLRrk rJchVh+AYy+eg7rrjhFBmRhEVCaa/l3teP3q7Ugf6HUnCkFfVvUVOkGm82Qk1uKfWPaWoU5KICpU /tXcO1nLV8y1ApMsL0LxSWV5t2b6X+tH1wsp9B8cQNvjXeh+PoX+hgE1RrsmrD75VUMaO1br4nj7 wHN9YIXV399OrhryGZ302Rqc9Jn5cX/t0wkRlThIH0jhtasexeFdncoF0rGVIcIRsVyU6e+7Qb6w DHGFyAUx2cRiKMv60fsmK2ag+KRSJMuLMGPRLCT1QvTJiiQYwMyFs03+G/0HD9uUeP/rhzHYnUG6 axDprgy6X0ih//X+iLWkhqeFjbKOiVXwORJnCkxWh1SbmhyC4+/rssjG+lPjTJYncOaGN+GY1RVx f93TDRGVOFEB3OciV1trYfDQmIs5ScNs4YkEct1z3GQAaItnaIDXipMp+dCvyZ5ADXXDEAmCRsZu xuw9D+TG7B+LFb2IUOrH2WVuyAZoTSDbuTxE/hjVc6vOLMGZX3kzimtlDeQY2EhEG8TRjImqvz0Z b7733Sh6c4lLjobeXKGsW7+BtnWKdDGXaaHgHoOtTbd9RADXi9VfMziMrn+jnqrmIPkLz1u7w7yf nTCpn2OaVGXtr9oMuKZIdoa2N8HSb8dJbO67znn2M7BVx9HxmPKV064/BufcfJwISnx0AMpgrI97 JNOV4pXzsfh3azDnMycMDb9yxNiPzmj22iKafexSIGROWt19jr2T2AoPvG50rD0aTyzgiwW8ExhZ Y4MVJDOewIqHa4hkj8vMFGYneDC9TuzxeOMHomP238uKGFB1RgnOvetELPtYddxf6XSnA1DFb68A WBz3aKY76QO9eHXtNqT390bTzEOyQdp9CNnGUiLpZr+exVzyQ0RcIGtLBACO9j7mNfR2piC6DzN0 929XPwLPffNkkgLjZrn4BzPZLA977xWt5ckRvNXPSZYlceLna0VMCof1RLSFmHkHgOVxj0ZQdN5Z j5ZvPo+BA6lo7ISgSv29mIgtCvMzPhRxgrx6l6zGCzT0JHUBz6wgqB/PCciNx49/wMQ/KCowJrvl iYzyksw2KGECrLjYqdrIrkdRfyTLk1h61XwsuXI+isoScX9lgmM1EW0jZv4ZgLVxj0aI0nnXq2j+ xnNIH+iNFIdFLBIb5FVWgxKKACb2blK2kfoVRKtSI8FbvQ/gWwZZQVojQJHXABAE3rSc6HN8YXTj VtuM6Pjp5pCzxuQJy6K1VTj+c8egeKHETQqQOiLaScy8BcDVcY9GyE3nna+i+VvPI70/BQSEMETE gohYH/rvoVmWaJYI8N0NIxZaQHxLxdz6bkhEdKJZHD/rZEvm4d5zSAFblqAMES/93smKBBatrcLi K2swe+HMuL8S4cjMIaIOYuYNAG6MezTC0em481V03PUqUttbowVuNi2s4htOXKInvoppRE94s88b pY3t/hS1biKhZWsVIYfrkiU+gXtNIxxGu3yxTJYnsfjqBVh8VQ2SZYU55UBwkO7dQcy8DsBtcQ9I GB7pA71o/ubzSG1vwcD+PpsrVlZIMKRILnuuUKQ+BbAnskqkHMEFyg7akou5RCY5mvf0q4SziuB8 qwdEuoYl+p5zzirHsi8swtyzpBn1JGInEdUBSlSWA9gR94iEkdN1/0F0PdCArvsbkOkctJPowmwh 0dmfbBdDGTdeVijLDQGOVA5PcG0FhloZgF+Eh4h45JynBKDy7eWoPm8eFl5WLVbJ5OQ+IloLKFGp BNAe94iEsZHa3or2u/aj57E2DNi5RbAu0ZCYhe3REo2XZPd9yWWp+AFYv9rXq5rJ7Qp5LleyIok5 b69A5VmVqP2gCMkUYCMRbQBsHZTUqkwlBg70IrW9FT3b29D3XBd6d3W6OIw3Oxq+dWJKbtmbCuC7 Ma4Mz7lPJp19BNFRGSI1CzlZnkTFOypR+Y5KlL6lBJVvl3k5U4y1RHQf4ERlCyQDNGXJdKXRt6sL fbs6MfB6H3p3d6FvdxcGuwYjqerITN8c8ZJIhscLsvpZqUR5EWa+aTZKTypF6UmlmLFoFkrfUopZ i2bF/TEI40sdEe0EnKhcC+A7cY9KmHiUuKSR6RrEwIE+DHalMdg1iMGuQbVDlrUCAInyJJIVRUiW FSFRkURQnsSsRbMxc9Gsgm0MJYwrHUQ0x9wxv4CdcY9KiIfZJ0uGRRgzj/h3VMUA0TboyUCCIAgj ZJt/x299sDPukQmCMCnZ5t/xReW+uEcmCMKko94EaA2+qGyJe3SCIEw6tmVvsKJCRB25dhAEQTgK t2dvyG4n+cgwX0gQBKFeJ3kiZIvKprhHKQjCpGFbro0RUREXSBCEEXB7ro25uunfFPdIBUEoeHK6 PkBuUdkGKYQTBOHobDjSA0NERbtAYq0IgnAk6nGUurYjLSa2CWKtCIKQm23a+MhJTlHRT7gdgiAI Q9l4tAePtuzpprhHLghCwbGFiOqPtsMRRUU/UWIrgiD4bHyjHd5ogfYNkNiKIAiKm97ISgHeQFQk EyQIgqYewwyJ0BvtoLvt74A0xhaE6cw6IhpW8uYNRQUAmHktgJ/FfVSCIMRCPREtGe7OwxIVAGDm rQBWxX10giBMOEuGE0sxvFGg1mc9JGgrCNONjSMRFGAElgogS3kIwjRjRG6PYSSWCohoE6TSVhCm Ax0AVo/miSMSFc21UOklQRCmLiN2ewwjFhVdu3IpJL4iCFOVm7RXMipGFFPxYeZ1AG6L++gFQcgr o4qj+IzG/QEAENEWDGMegCAIk4Z6jDKO4jNqS8XAzFsAXB33pyEIwpjoAFA32jiKz5hFBZDCOEGY AtRlrzQ4Wkbt/mRxKWQtZkGYrKzPl6AAebJUADvxcCuA5RP+kQiCMFrW6/ho3siXpWJSzashFosg TAY6MA6CAuTRUjFoi2UTJHgrCIVKB4DV+XR5fPJmqRiIqIOI1kHSzYJQiNQjj0HZXORdVAxEtAEi LIJQSOyEslDqx/NNxk1UACssqyFzhQQhbm7CBAgKMA4xlVww82KoznHLJ+L9BEGwdEBNDtw0UW84 IaJiYOYNAG6cyPcUhGnMTgCXToR14jOhogJYq2UrpJG2IIwnG3X4YcIZ15hKLojIzIKUIK4g5J9t UNmdDXENYMJFxaAPegmkk5wg5IMOAF8ionGrPxkuE+7+5EL3ZrkR4hIJwkjpgMrsbNJV7bFTEKJi EHERhGHTgQITE0NBiYpBi8vVkHYKgpBNBwpUTAwFKSoGZl4FYB1kHpEgbANwL4DbC1VMDAUtKgad hl4FsV6E6UUHVCLjXiLaFvdghsukEBUfERhhitOBSSgkPpNOVHx0m4VV+v+7IdMAhMlHB5Rrsw3A I3Gng/PBpBaVbLTILAdwGlQNzGn6fmXcYxOmPR36/04Ar+rbbRNdQj8RTClRORrabVoMJTCVevPi uMclTDnaAXTqv+uhxWQqiseR+P/s+9IsKevYswAAACV0RVh0ZGF0ZTpjcmVhdGUAMjAyMi0wNy0x OVQxNDoxNjo1NSswMjowMBPYLIsAAAAldEVYdGRhdGU6bW9kaWZ5ADIwMjItMDctMTlUMTQ6MTY6 NTUrMDI6MDBihZQ3AAAAAElFTkSuQmCC'
            ></image>
        </svg>
    );
}

export function OpenApiIcon(className?: string, height?: number | string | undefined, width?: number | string | undefined) {
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            xmlSpace="preserve"
            viewBox="0 0 112 112"
            height={height}
            width={width}
            className={className}
        >
            <path
                fill="#93d500"
                d="M74.909 189.069H45.352c.005.144.009.289.017.433.012.278.032.555.049.833.008.119.013.238.022.356.023.322.051.642.08.962l.02.215a46.218 46.218 0 0 0 .126 1.168 43.62 43.62 0 0 0 .154 1.158c.339 2.356.848 4.69 1.527 6.984.003.01.007.019.009.029a43.315 43.315 0 0 0 .373 1.203c.105.323.215.645.325.968.029.081.056.163.086.244.099.279.2.558.304.837l.143.378.27.691c.069.173.141.346.213.519.074.18.15.359.226.54.094.22.192.439.289.658l.175.391c.12.263.244.526.368.787.041.084.08.168.122.252.145.301.293.599.443.895.025.046.047.091.07.137.169.328.341.656.518.981.008.014.016.028.023.044.037.068.078.133.115.2l25.243-15.207.093-.056a20.129 20.129 0 0 1-1.846-6.6z"
                style={{
                    fill: "#ec7a08",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#4d5a31"
                d="m82.173 202.638-.071.071-20.819 20.82c.107.1.213.201.323.298.194.176.392.351.589.523.102.091.202.181.304.269.236.204.474.403.711.602l.192.16a47.32 47.32 0 0 0 .917.737 62.01 62.01 0 0 0 .928.711 50.044 50.044 0 0 0 3.895 2.633l.139.085c.255.153.51.304.767.453l.471.268c.148.086.296.168.446.251a63.783 63.783 0 0 0 .927.499c.757.396 1.527.764 2.303 1.118l.739-1.794 10.471-25.429.039-.094a20.195 20.195 0 0 1-3.271-2.181z"
                style={{
                    fill: "#06c",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#6ba43a"
                d="M80.005 200.564a20.653 20.653 0 0 1-1.767-2.28 21.467 21.467 0 0 1-.54-.843l-25.275 15.226c.388.645.793 1.273 1.206 1.894l.041.065.015.023c.014.02.026.042.04.063l.004.006.101.148.006.009.003.004c.439.649.89 1.288 1.355 1.91l.031.04.03.039a45.939 45.939 0 0 0 1.351 1.715l.158.191c.2.239.4.477.604.713.087.101.178.202.266.302.174.198.346.395.524.59.097.107.198.215.297.322l.135.146c.13.14.259.28.39.419.052.055.107.109.16.164.23.24.462.48.699.716l20.85-20.85a17.977 17.977 0 0 1-.684-.732z"
                style={{
                    fill: "#ac5608",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#4d5a31"
                d="M107.642 202.627c-.229.185-.461.366-.697.54l.052.087 15.202 25.235c.704-.46 1.4-.934 2.08-1.432a50.463 50.463 0 0 0 4.267-3.527l-20.821-20.821z"
                style={{
                    fill: "#06c",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#93d500"
                d="m74.961 105.035-.006.003.015-.008a.024.024 0 0 1-.009.005zM75.004 105.012c.066-.039.133-.072.198-.112-.065.04-.132.075-.198.112z"
            />
            <path
                fill="#93d500"
                d="m119.99 228.696-.516-.856-14.19-23.555c-.287.173-.581.329-.874.487a20.15 20.15 0 0 1-9.528 2.404c-1.936 0-3.871-.28-5.742-.838-.319-.095-.63-.22-.945-.332-.315-.111-.634-.207-.944-.335l-10.464 25.412-.41.996-.351.853-.002.004.082.031.086.033h.001l.002.001.02.008c.247.101.496.188.744.285.311.121.622.244.934.358.159.058.317.126.476.182h.001a49.947 49.947 0 0 0 10.119 2.422c.135.016.269.035.404.054l.424.046c.266.03.531.061.798.087l.198.017c.327.031.654.059.979.082.111.008.223.013.333.021.287.019.572.037.858.05.175.01.35.015.526.021.227.008.453.017.682.024.327.008.657.011.986.012.078 0 .155.002.232.003a49.76 49.76 0 0 0 8.233-.686c.046-.007.091-.015.138-.021.288-.05.576-.104.864-.157l.491-.095.505-.106c.281-.059.561-.12.842-.185.05-.011.101-.021.152-.035a49.851 49.851 0 0 0 11.897-4.436l.001-.001c.246-.13.486-.278.731-.411.292-.16.582-.325.872-.491.201-.115.404-.221.603-.34l.001-.001.006-.004h.001l.009-.005.004-.003-.037-.063.037.063.006-.003.009-.005.033-.02.195-.117zM82.185 171.512c.23-.186.462-.366.697-.54l-.052-.087-15.201-25.235c-.706.461-1.404.936-2.085 1.436a49.645 49.645 0 0 0-4.262 3.522l20.821 20.821z"
                style={{
                    fill: "#ec7a08",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#4d5a31"
                d="M59.838 151.994c-.237.237-.461.482-.692.722-.231.24-.466.479-.692.723a49.743 49.743 0 0 0-4.212 5.22c-.061.085-.122.174-.182.261a49.018 49.018 0 0 0-1.008 1.522 49.48 49.48 0 0 0-7.7 24.627c-.013.333-.02.667-.027 1-.007.333-.017.667-.017 1h29.488c0-.334.031-.666.048-1 .017-.334.022-.668.055-1a20.013 20.013 0 0 1 4.447-10.739c.21-.256.447-.496.672-.743.224-.247.432-.504.671-.742zM120.681 144.675l-.122-.073c-.259-.159-.521-.312-.783-.465-.152-.088-.304-.173-.457-.26-.154-.086-.306-.172-.461-.256-.266-.146-.533-.29-.801-.432l-.126-.066a49.592 49.592 0 0 0-6.649-2.878 49.774 49.774 0 0 0-9.936-2.358 58.984 58.984 0 0 0-.415-.056c-.139-.017-.277-.031-.415-.046a42.608 42.608 0 0 0-.801-.087c-.074-.007-.149-.012-.224-.02a50.991 50.991 0 0 0-.953-.08c-.123-.009-.248-.016-.371-.023-.272-.018-.547-.037-.819-.049-.146-.008-.29-.012-.434-.017l-.001 29.444v.115c1.517.157 3.02.48 4.478.975l21.754-21.754a48.287 48.287 0 0 0-2.464-1.614z"
                style={{
                    fill: "#06c",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#6ba43a"
                d="M93.914 137.485c-.333.007-.667.008-1 .021a49.856 49.856 0 0 0-6.233.643l-.136.023c-.29.05-.577.103-.865.157-.163.031-.327.061-.49.094-.17.034-.339.069-.508.106-.28.058-.56.119-.84.184l-.153.034a49.891 49.891 0 0 0-11.898 4.438h-.001c-.245.13-.484.277-.728.411-.292.16-.582.325-.872.491-.215.124-.434.238-.648.366l-.007.004h-.001l-.045.026c-.056.034-.114.062-.17.096l.003.005.516.857 14.705 24.412c.287-.173.581-.33.874-.487.295-.159.594-.308.895-.451a20.051 20.051 0 0 1 7.601-1.929c.333-.017.666-.034 1-.034l.001-29.487c-.334 0-.667.014-1 .02z"
                style={{
                    fill: "#ac5608",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#4d5a31"
                d="M144.458 184.631a53.77 53.77 0 0 0-.048-.795c-.008-.132-.015-.263-.026-.397a41.966 41.966 0 0 0-.077-.934c-.006-.081-.014-.161-.021-.242a60.396 60.396 0 0 0-.111-1.043l-.01-.084-.005-.04c-.046-.375-.096-.75-.149-1.124-.001-.011-.002-.025-.005-.035a49.558 49.558 0 0 0-1.524-6.972l-.014-.044c-.107-.356-.216-.71-.328-1.063-.015-.046-.031-.093-.045-.14a66.772 66.772 0 0 0-.412-1.212 50.701 50.701 0 0 0-.714-1.892c-.072-.18-.144-.357-.218-.534-.072-.176-.146-.35-.22-.526a80.106 80.106 0 0 0-.294-.671c-.056-.125-.112-.252-.17-.378a63.783 63.783 0 0 0-.373-.797l-.116-.242a58.592 58.592 0 0 0-.448-.906l-.065-.125c-.17-.331-.344-.663-.521-.99l-.019-.035a49.533 49.533 0 0 0-2.822-4.578l-21.761 21.762a20.5 20.5 0 0 1 .974 4.477h29.56c-.007-.149-.011-.295-.018-.44z"
                style={{
                    fill: "#06c",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#6ba43a"
                d="M115.03 187.069c0 .334-.031.666-.048 1-.016.334-.022.668-.055 1a20.022 20.022 0 0 1-4.446 10.74c-.21.256-.447.496-.672.743-.224.247-.432.504-.671.742l20.851 20.85c.237-.237.46-.482.691-.723.231-.241.466-.479.691-.723a49.783 49.783 0 0 0 4.224-5.236l.148-.214c.155-.223.306-.448.458-.673.133-.201.266-.402.395-.605.064-.097.128-.198.19-.295a49.46 49.46 0 0 0 7.685-24.607c.013-.333.02-.667.027-1 .007-.333.017-.666.017-1H115.03Z"
                style={{
                    fill: "#ac5608",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
            <path
                fill="#424143"
                d="M153.276 128.706c-5.395-5.395-14.142-5.395-19.536 0-4.304 4.303-5.164 10.736-2.601 15.902L101.048 174.7c-5.166-2.562-11.599-1.703-15.903 2.6-5.395 5.395-5.394 14.142 0 19.537 5.396 5.395 14.143 5.393 19.538-.001 4.303-4.303 5.162-10.736 2.599-15.903l30.091-30.091c5.167 2.562 11.599 1.703 15.902-2.601 5.395-5.392 5.395-14.14.001-19.535z"
                style={{
                    fill: "#424143",
                    fillOpacity: 1,
                }}
                transform="translate(-45.308 -124.66)"
            />
        </svg>
    )
}