/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.monitor;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.monitor.SerializableFileTime;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SerializableFileTimeTest {
    SerializableFileTimeTest() {
    }

    @Test
    void testSerializable() throws IOException {
        SerializableFileTime expected = new SerializableFileTime(Files.getLastModifiedTime(PathUtils.current(), new LinkOption[0]));
        SerializableFileTime actual = (SerializableFileTime)SerializationUtils.roundtrip((Serializable)expected);
        Assertions.assertEquals((Object)expected, (Object)actual);
        FileTime expectedFt = expected.unwrap();
        Assertions.assertEquals((Object)expectedFt, (Object)actual.unwrap());
        Assertions.assertEquals((int)0, (int)actual.compareTo(expectedFt));
        Assertions.assertEquals((int)expectedFt.hashCode(), (int)actual.hashCode());
        Assertions.assertEquals((Object)expectedFt.toInstant(), (Object)actual.toInstant());
        Assertions.assertEquals((long)expectedFt.toMillis(), (long)actual.toMillis());
        Assertions.assertEquals((Object)expectedFt.toString(), (Object)actual.toString());
    }
}

