/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Functions;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.Streams;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.Executable;
import org.xml.sax.SAXException;

@Deprecated
class StreamsTest
extends AbstractLangTest {
    StreamsTest() {
    }

    protected <T extends Throwable> Functions.FailableConsumer<String, T> asIntConsumer(T throwable) {
        return s -> {
            int i = Integer.parseInt(s);
            if (i == 4) {
                throw throwable;
            }
        };
    }

    protected <T extends Throwable> Functions.FailablePredicate<Integer, T> asIntPredicate(T phrowable) {
        return i -> {
            if (i == 5 && phrowable != null) {
                throw phrowable;
            }
            return i % 2 == 0;
        };
    }

    private void assertEvenNumbers(List<Integer> output) {
        Assertions.assertEquals((int)3, (int)output.size());
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)((i + 1) * 2), (int)output.get(i));
        }
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamFilterFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).filter(this.asIntPredicate(null)).collect(Collectors.toList());
        this.assertEvenNumbers(output);
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid argument: 5");
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(iae)).collect(Collectors.toList());
            IllegalArgumentException thrown = LangAssertions.assertIllegalArgumentException(testMethod);
            Assertions.assertEquals((Object)"Invalid argument: 5", (Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(oome)).collect(Collectors.toList());
            OutOfMemoryError thrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(se)).collect(Collectors.toList());
            UndeclaredThrowableException thrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
            Assertions.assertEquals((Object)se, (Object)thrown.getCause());
        }));
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamForEachFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException ise = new IllegalArgumentException();
            Executable testMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(ise));
            IllegalArgumentException thrown = LangAssertions.assertIllegalArgumentException(testMethod);
            Assertions.assertNull((Object)thrown.getMessage());
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable oomeTestMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(oome));
            OutOfMemoryError oomeThrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)oomeTestMethod);
            Assertions.assertNull((Object)oomeThrown.getMessage());
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable seTestMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(se));
            UndeclaredThrowableException seThrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)seTestMethod);
            Assertions.assertNull((Object)seThrown.getMessage());
            Assertions.assertEquals((Object)se, (Object)seThrown.getCause());
        }));
    }

    @Test
    void testSimpleStreamFilter() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).filter(i -> i % 2 == 0).collect(Collectors.toList());
        this.assertEvenNumbers(output);
    }

    @Test
    void testSimpleStreamForEach() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        ArrayList output = new ArrayList();
        Functions.stream(input).forEach(s -> output.add(Integer.valueOf(s)));
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    void testSimpleStreamMap() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    void testSimpleStreamMapFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4 ", "5", "6");
        Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).collect(Collectors.toList());
        NumberFormatException thrown = (NumberFormatException)Assertions.assertThrows(NumberFormatException.class, (Executable)testMethod);
        Assertions.assertEquals((Object)"For input string: \"4 \"", (Object)thrown.getMessage());
    }

    @Test
    void testToArray() {
        String[] array = (String[])Arrays.asList("2", "3", "1").stream().collect(Streams.toArray(String.class));
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertEquals((Object)"2", (Object)array[0]);
        Assertions.assertEquals((Object)"3", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
    }
}

