/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DiffResultTest
extends AbstractLangTest {
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;
    private static final SimpleClass SIMPLE_FALSE = new SimpleClass(false);
    private static final SimpleClass SIMPLE_TRUE = new SimpleClass(true);

    DiffResultTest() {
    }

    @Test
    void testDefaultStyle() {
        DiffResult diffResult = new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), ToStringStyle.DEFAULT_STYLE, "%s differs from %s");
        Assertions.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)diffResult.getToStringStyle());
    }

    @Test
    void testIterator() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        Iterator expectedIterator = diffs.iterator();
        DiffResult list = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE, "%s differs from %s");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Assertions.assertTrue((boolean)expectedIterator.hasNext());
            Assertions.assertEquals(expectedIterator.next(), iterator.next());
        }
    }

    @Test
    void testLeftAndRightGetters() {
        SimpleClass left = new SimpleClass(true);
        SimpleClass right = new SimpleClass(false);
        List diffs = left.diff(right).getDiffs();
        DiffResult diffResult = new DiffResult((Object)left, (Object)right, diffs, SHORT_STYLE, "%s differs from %s");
        Assertions.assertEquals((Object)left, (Object)diffResult.getLeft());
        Assertions.assertEquals((Object)right, (Object)diffResult.getRight());
    }

    @Test
    void testListIsNonModifiable() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        DiffResult result = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE, "%s differs from %s");
        Assertions.assertEquals((Object)diffs, (Object)result.getDiffs());
        Assertions.assertEquals((int)1, (int)result.getNumberOfDiffs());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> result.getDiffs().remove(0));
    }

    @Test
    void testNoDifferencesString() {
        DiffResult diffResult = DiffBuilder.builder().setLeft((Object)SIMPLE_TRUE).setRight((Object)SIMPLE_TRUE).setStyle(SHORT_STYLE).build().build();
        Assertions.assertEquals((Object)"", (Object)diffResult.toString());
    }

    @Test
    void testNullLhs() {
        LangAssertions.assertNullPointerException(() -> new DiffResult(null, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE, "%s differs from %s"));
    }

    @Test
    void testNullList() {
        LangAssertions.assertNullPointerException(() -> new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, null, SHORT_STYLE, null));
    }

    @Test
    void testNullRhs() {
        LangAssertions.assertNullPointerException(() -> new DiffResult((Object)SIMPLE_TRUE, null, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE, "%s differs from %s"));
    }

    @Test
    void testToStringFormat() {
        DiffResult result = DiffBuilder.builder().setLeft((Object)new EmptyClass()).setRight((Object)new EmptyClass()).setStyle(ToStringStyle.SHORT_PREFIX_STYLE).setToStringFormat("%s <> %s").build().append("test", false, true).build();
        Assertions.assertEquals((Object)"DiffResultTest.EmptyClass[test=false] <> DiffResultTest.EmptyClass[test=true]", (Object)result.toString());
    }

    @Test
    void testToStringOutput() {
        DiffResult result = DiffBuilder.builder().setLeft((Object)new EmptyClass()).setRight((Object)new EmptyClass()).setStyle(ToStringStyle.SHORT_PREFIX_STYLE).build().append("test", false, true).build();
        Assertions.assertEquals((Object)"DiffResultTest.EmptyClass[test=false] differs from DiffResultTest.EmptyClass[test=true]", (Object)result.toString());
    }

    @Test
    void testToStringSpecifyStyleOutput() {
        DiffResult<SimpleClass> result = SIMPLE_FALSE.diff(SIMPLE_TRUE);
        Assertions.assertEquals((Object)result.getToStringStyle(), (Object)SHORT_STYLE);
        String lhsString = new ToStringBuilder((Object)SIMPLE_FALSE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_FALSE.booleanField).build();
        String rhsString = new ToStringBuilder((Object)SIMPLE_TRUE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_TRUE.booleanField).build();
        Assertions.assertEquals((Object)String.format("%s differs from %s", lhsString, rhsString), (Object)result.toString(ToStringStyle.MULTI_LINE_STYLE));
    }

    private static final class SimpleClass
    implements Diffable<SimpleClass> {
        private final boolean booleanField;

        static String getFieldName() {
            return "booleanField";
        }

        SimpleClass(boolean booleanField) {
            this.booleanField = booleanField;
        }

        public DiffResult<SimpleClass> diff(SimpleClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, ToStringStyle.SHORT_PREFIX_STYLE).append(SimpleClass.getFieldName(), this.booleanField, obj.booleanField).build();
        }
    }

    private static final class EmptyClass {
        private EmptyClass() {
        }
    }
}

