/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PreambleUtilTest {
    @Test
    public void checkInsertsAndExtracts() {
        int bytes = 32;
        try (Arena arena = Arena.ofConfined();){
            MemorySegment offHeapSeg = arena.allocate(32L);
            MemorySegment onHeapSeg = MemorySegment.ofArray(new byte[32]);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            int v = 255;
            PreambleUtil.insertPreLongs((MemorySegment)onHeapSeg, (int)v);
            int onH = PreambleUtil.extractPreLongs((MemorySegment)onHeapSeg);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertPreLongs((MemorySegment)offHeapSeg, (int)v);
            int offH = PreambleUtil.extractPreLongs((MemorySegment)offHeapSeg);
            Assert.assertEquals((int)offH, (int)v);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            PreambleUtil.insertSerVer((MemorySegment)onHeapSeg, (int)v);
            onH = PreambleUtil.extractSerVer((MemorySegment)onHeapSeg);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertSerVer((MemorySegment)offHeapSeg, (int)v);
            offH = PreambleUtil.extractSerVer((MemorySegment)offHeapSeg);
            Assert.assertEquals((int)offH, (int)v);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            PreambleUtil.insertFamilyID((MemorySegment)onHeapSeg, (int)v);
            onH = PreambleUtil.extractFamilyID((MemorySegment)onHeapSeg);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertFamilyID((MemorySegment)offHeapSeg, (int)v);
            offH = PreambleUtil.extractFamilyID((MemorySegment)offHeapSeg);
            Assert.assertEquals((int)offH, (int)v);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            PreambleUtil.insertFlags((MemorySegment)onHeapSeg, (int)v);
            onH = PreambleUtil.extractFlags((MemorySegment)onHeapSeg);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertFlags((MemorySegment)offHeapSeg, (int)v);
            offH = PreambleUtil.extractFlags((MemorySegment)offHeapSeg);
            Assert.assertEquals((int)offH, (int)v);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            v = 65535;
            PreambleUtil.insertK((MemorySegment)onHeapSeg, (int)v);
            onH = PreambleUtil.extractK((MemorySegment)onHeapSeg);
            Assert.assertEquals((int)onH, (int)v);
            PreambleUtil.insertK((MemorySegment)offHeapSeg, (int)v);
            offH = PreambleUtil.extractK((MemorySegment)offHeapSeg);
            Assert.assertEquals((int)offH, (int)v);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            long vL = 0x40000000L;
            PreambleUtil.insertN((MemorySegment)onHeapSeg, (long)0x40000000L);
            long onHL = PreambleUtil.extractN((MemorySegment)onHeapSeg);
            Assert.assertEquals((long)onHL, (long)0x40000000L);
            PreambleUtil.insertN((MemorySegment)offHeapSeg, (long)0x40000000L);
            long offHL = PreambleUtil.extractN((MemorySegment)offHeapSeg);
            Assert.assertEquals((long)offHL, (long)0x40000000L);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            double vD = 1.099511627776E12;
            PreambleUtil.insertMinDouble((MemorySegment)onHeapSeg, (double)1.099511627776E12);
            double onHD = PreambleUtil.extractMinDouble((MemorySegment)onHeapSeg);
            Assert.assertEquals((double)onHD, (double)1.099511627776E12);
            PreambleUtil.insertMinDouble((MemorySegment)offHeapSeg, (double)1.099511627776E12);
            double offHD = PreambleUtil.extractMinDouble((MemorySegment)offHeapSeg);
            Assert.assertEquals((double)offHD, (double)1.099511627776E12);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
            PreambleUtil.insertMaxDouble((MemorySegment)onHeapSeg, (double)1.099511627776E12);
            onHD = PreambleUtil.extractMaxDouble((MemorySegment)onHeapSeg);
            Assert.assertEquals((double)onHD, (double)1.099511627776E12);
            PreambleUtil.insertMaxDouble((MemorySegment)offHeapSeg, (double)1.099511627776E12);
            offHD = PreambleUtil.extractMaxDouble((MemorySegment)offHeapSeg);
            Assert.assertEquals((double)offHD, (double)1.099511627776E12);
            Util.clear((MemorySegment)onHeapSeg);
            Util.clear((MemorySegment)offHeapSeg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void checkToString() {
        int k = 128;
        int n = 1000000;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(128).build();
        for (int i = 0; i < 1000000; ++i) {
            qs.update((double)i);
        }
        byte[] byteArr = qs.toByteArray();
        QuantilesDoublesSketch.toString((byte[])byteArr);
        PreambleUtilTest.println(QuantilesDoublesSketch.toString((MemorySegment)MemorySegment.ofArray(byteArr)));
    }

    @Test
    public void checkToStringEmpty() {
        int k = 128;
        UpdatableQuantilesDoublesSketch qs = QuantilesDoublesSketch.builder().setK(128).build();
        byte[] byteArr = qs.toByteArray();
        PreambleUtilTest.println(PreambleUtil.toString((byte[])byteArr, (boolean)true));
    }

    @Test
    public void printlnTest() {
        PreambleUtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

