/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBBlobData {
    private static final Logger log = LoggerFactory.getLogger(DBBlobData.class);
    private InputStream inputStream = null;
    private int length = 0;
    private static String defaultEncoding = null;

    public DBBlobData(InputStream inputStream, int length) throws IllegalArgumentException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream was null");
        }
        this.inputStream = inputStream;
        this.length = length;
    }

    public DBBlobData(byte[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data was null");
        }
        this.inputStream = new ByteArrayInputStream(data);
        this.length = data.length;
    }

    public DBBlobData(String text, String encoding) throws IllegalArgumentException {
        byte[] byteArray = null;
        if (text == null) {
            throw new IllegalArgumentException("text was null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding was null");
        }
        try {
            byteArray = text.getBytes(encoding);
            this.inputStream = new ByteArrayInputStream(byteArray);
            this.length = byteArray.length;
        }
        catch (UnsupportedEncodingException uee) {
            log.error("Unsupported encoding " + encoding, (Throwable)uee);
            throw new IllegalArgumentException("encoding " + encoding + " is unsupported");
        }
    }

    public DBBlobData(String text) throws IllegalArgumentException {
        this(text, defaultEncoding);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public int getLength() {
        return this.length;
    }

    public static void setDefaultEncoding(String defaultEncoding) {
        DBBlobData.defaultEncoding = defaultEncoding;
    }
}

