/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.oak.segment.remote;

import org.apache.jackrabbit.oak.segment.spi.persistence.GCGeneration;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;

import java.util.UUID;

public class RemoteSegmentArchiveEntry implements SegmentArchiveEntry {

    private final UUID uuid;

    private final int position;

    private final int length;

    private final GCGeneration gcGeneration;

    public RemoteSegmentArchiveEntry(long msb, long lsb, int position, int length, int generation, int fullGeneration, boolean compacted) {
        this.uuid = new UUID(msb, lsb);
        this.position = position;
        this.length = length;
        this.gcGeneration = GCGeneration.newGCGeneration(generation, fullGeneration, compacted);
    }

    @Override
    public long getMsb() {
        return uuid.getMostSignificantBits();
    }

    @Override
    public long getLsb() {
        return uuid.getLeastSignificantBits();
    }

    public int getPosition() {
        return position;
    }

    @Override
    public int getLength() {
        return length;
    }

    @Override
    public int getGeneration() {
        return gcGeneration.getGeneration();
    }

    @Override
    public int getFullGeneration() {
        return gcGeneration.getFullGeneration();
    }

    @Override
    public boolean isCompacted() {
        return gcGeneration.isCompacted();
    }

    UUID getUuid() {
        return uuid;
    }
}
