/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;

public class UpgraderHelper {
    static final String CONTEXT = "context";
    static final String CP_TYPE = "connectionPoolType";
    static final String BONECP = "BONECP";
    static final String HIKARICP = "HIKARICP";
    static final String PARTITION_COUNT_PARAM = "qpid.jdbcstore.bonecp.partitionCount";
    static final String MAX_POOL_SIZE_OLD_PARAM = "qpid.jdbcstore.bonecp.maxConnectionsPerPartition";
    static final String MIN_IDLE_OLD_PARAM = "qpid.jdbcstore.bonecp.minConnectionsPerPartition";
    static final String MAX_POOL_SIZE_PARAM = "qpid.jdbcstore.hikaricp.maximumPoolSize";
    static final String MIN_IDLE_PARAM = "qpid.jdbcstore.hikaricp.minimumIdle";
    static final Map<String, String> RENAME_MAPPING = Map.of("qpid.jdbcstore.bonecp.maxConnectionsPerPartition", "qpid.jdbcstore.hikaricp.maximumPoolSize", "qpid.jdbcstore.bonecp.minConnectionsPerPartition", "qpid.jdbcstore.hikaricp.minimumIdle");
    public static final Map<String, String> MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES = new HashMap<String, String>();

    public static Map<String, String> renameContextVariables(Map<String, String> context, Map<String, String> oldToNewNameMapping) {
        HashMap<String, String> newContext = new HashMap<String, String>(context);
        oldToNewNameMapping.forEach((oldName, newName) -> {
            if (newContext.containsKey(oldName)) {
                Object object = newContext.remove(oldName);
                String value = object == null ? null : String.valueOf(object);
                newContext.put((String)newName, value);
            }
        });
        return newContext;
    }

    public static Map<String, String> reverse(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static ConfiguredObjectRecord upgradeConnectionPool(ConfiguredObjectRecord record) {
        Object contextObject;
        Map<String, Object> attributes = record.getAttributes();
        HashMap<String, Object> updatedAttributes = new HashMap<String, Object>(record.getAttributes());
        if (BONECP.equals(attributes.get(CP_TYPE))) {
            updatedAttributes.put(CP_TYPE, HIKARICP);
        }
        if ((contextObject = attributes.get(CONTEXT)) instanceof Map) {
            int minIdle;
            Map context = (Map)contextObject;
            Map<String, String> newContext = UpgraderHelper.renameContextVariables(context, RENAME_MAPPING);
            int partitionCount = newContext.get(PARTITION_COUNT_PARAM) != null ? Integer.parseInt(String.valueOf(newContext.remove(PARTITION_COUNT_PARAM))) : 0;
            int maximumPoolSize = newContext.get(MAX_POOL_SIZE_PARAM) != null && partitionCount != 0 ? Integer.parseInt(String.valueOf(newContext.get(MAX_POOL_SIZE_PARAM))) * partitionCount : 40;
            int n = minIdle = newContext.get(MIN_IDLE_PARAM) != null && partitionCount != 0 ? Integer.parseInt(String.valueOf(newContext.get(MIN_IDLE_PARAM))) * partitionCount : 20;
            if (BONECP.equals(attributes.get(CP_TYPE)) || "Broker".equals(record.getType())) {
                if (newContext.containsKey(MAX_POOL_SIZE_PARAM)) {
                    newContext.put(MAX_POOL_SIZE_PARAM, String.valueOf(maximumPoolSize));
                }
                if (newContext.containsKey(MIN_IDLE_PARAM)) {
                    newContext.put(MIN_IDLE_PARAM, String.valueOf(minIdle));
                }
            }
            updatedAttributes.put(CONTEXT, newContext);
        }
        return new ConfiguredObjectRecordImpl(record.getId(), record.getType(), updatedAttributes, record.getParents());
    }

    static {
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.protocolWhiteList", "qpid.security.tls.protocolAllowList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.protocolBlackList", "qpid.security.tls.protocolDenyList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.cipherSuiteWhiteList", "qpid.security.tls.cipherSuiteAllowList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.cipherSuiteBlackList", "qpid.security.tls.cipherSuiteDenyList");
    }
}

