/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.query;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.aggregation.AbstractAggregationExpression;
import org.apache.qpid.server.query.engine.parsing.factory.CollectorFactory;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public class HavingExpression<T, R>
extends AbstractExpressionNode<T, R>
implements Predicate<T> {
    private Map<String, Object> _result;

    public HavingExpression(SelectExpression<T, R> selectExpression, ExpressionNode<T, R> expression) {
        super(selectExpression, expression);
    }

    @Override
    public R apply(T value) {
        return (R)this.evaluateChild(1, value);
    }

    @Override
    public boolean test(T value) {
        return (Boolean)this.apply(value);
    }

    public <A> void applyAggregation(SelectExpression<T, R> selectExpression, List<T> items) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (AbstractAggregationExpression aggregation : this.getAggregations()) {
            Expression source = aggregation.getSource();
            Collector collector = CollectorFactory.collector(aggregation.getCollectorType()).apply(source);
            List<ProjectionExpression<T, R>> groupByItems = selectExpression.getGroupBy();
            for (int i = groupByItems.size() - 1; i >= 0; --i) {
                collector = Collectors.groupingBy((Function)groupByItems.get(i), collector);
            }
            Map aggregationResult = (Map)items.stream().collect(collector);
            aggregation.setValue(aggregationResult);
            aggregation.setSelect(selectExpression);
            if (result.isEmpty()) {
                result.putAll(aggregationResult);
                continue;
            }
            for (Map.Entry entry : result.entrySet()) {
                Boolean value = (Boolean)aggregationResult.get(entry.getKey());
                if (value == null) continue;
                entry.setValue((Boolean)entry.getValue() != false && value != false);
            }
        }
        this._result = result;
    }

    public void filter(Map<String, R> result) {
        this.filter(result, this._result);
    }

    private void filter(Map<String, R> result, Map<String, Object> havingResult) {
        for (Map.Entry<String, Object> entry : havingResult.entrySet()) {
            Boolean flag;
            Object object = entry.getValue();
            if (object instanceof Boolean && !(flag = (Boolean)object).booleanValue()) {
                result.remove(entry.getKey());
            }
            if (!(object instanceof Map) || !result.containsKey(entry.getKey())) continue;
            this.filter((Map)result.get(entry.getKey()), (Map)object);
            if (!(result.get(entry.getKey()) instanceof Map) || !((Map)result.get(entry.getKey())).isEmpty()) continue;
            result.remove(entry.getKey());
        }
    }
}

