/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.TypeIdResolver;

public abstract class TypeDeserializer {
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    public abstract JsonTypeInfo.As getTypeInclusion();

    public abstract String getPropertyName();

    public abstract TypeIdResolver getTypeIdResolver();

    public abstract Class<?> getDefaultImpl();

    public boolean hasDefaultImpl() {
        return this.getDefaultImpl() != null;
    }

    public abstract Object deserializeTypedFromObject(JsonParser var1, DeserializationContext var2) throws JacksonException;

    public abstract Object deserializeTypedFromArray(JsonParser var1, DeserializationContext var2) throws JacksonException;

    public abstract Object deserializeTypedFromScalar(JsonParser var1, DeserializationContext var2) throws JacksonException;

    public abstract Object deserializeTypedFromAny(JsonParser var1, DeserializationContext var2) throws JacksonException;

    public static Object deserializeIfNatural(JsonParser p, DeserializationContext ctxt, JavaType baseType) throws JacksonException {
        return TypeDeserializer.deserializeIfNatural(p, ctxt, baseType.getRawClass());
    }

    public static Object deserializeIfNatural(JsonParser p, DeserializationContext ctxt, Class<?> base) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == null) {
            return null;
        }
        switch (t) {
            case VALUE_STRING: {
                if (!base.isAssignableFrom(String.class)) break;
                return p.getString();
            }
            case VALUE_NUMBER_INT: {
                if (!base.isAssignableFrom(Integer.class)) break;
                return p.getIntValue();
            }
            case VALUE_NUMBER_FLOAT: {
                if (!base.isAssignableFrom(Double.class)) break;
                return p.getDoubleValue();
            }
            case VALUE_TRUE: {
                if (!base.isAssignableFrom(Boolean.class)) break;
                return Boolean.TRUE;
            }
            case VALUE_FALSE: {
                if (!base.isAssignableFrom(Boolean.class)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

