/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.via;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.impl.via.ChildResourceViaProvider;
import org.apache.sling.models.spi.ViaProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ChildResourceViaProviderTest {
    private ChildResourceViaProvider provider = new ChildResourceViaProvider();
    @Mock
    private Resource resource;
    @Mock
    private Resource childResource;
    @Mock
    private SlingJakartaHttpServletRequest jakartaRequest;
    @Deprecated
    @Mock
    private SlingHttpServletRequest javaxRequest;

    ChildResourceViaProviderTest() {
    }

    @BeforeEach
    void init() {
        Mockito.lenient().when((Object)this.resource.getChild("child")).thenReturn((Object)this.childResource);
        Mockito.lenient().when((Object)this.jakartaRequest.getResource()).thenReturn((Object)this.resource);
        Mockito.lenient().when((Object)this.javaxRequest.getResource()).thenReturn((Object)this.resource);
    }

    @Test
    void testResource() {
        Object adaptable = this.provider.getAdaptable((Object)this.resource, "child");
        Assertions.assertEquals((Object)adaptable, (Object)this.childResource);
    }

    @Test
    void testResourceWithBlank() {
        Object adaptable = this.provider.getAdaptable((Object)this.resource, "");
        Assertions.assertEquals((Object)ViaProvider.ORIGINAL, (Object)adaptable);
    }

    @Test
    void testResourceWithOtherAdaptable() {
        Assertions.assertNull((Object)this.provider.getAdaptable(new Object(), "child"));
    }

    @Test
    void testJakartaRequest() {
        Object adaptable = this.provider.getAdaptable((Object)this.jakartaRequest, "child");
        Resource adaptableResource = ((SlingJakartaHttpServletRequest)adaptable).getResource();
        Assertions.assertEquals((Object)adaptableResource, (Object)this.childResource);
    }

    @Test
    void testJakartaRequestWhenChildDoesNotExist() {
        Assertions.assertNull((Object)this.provider.getAdaptable((Object)this.jakartaRequest, "notexisting"));
    }

    @Deprecated
    @Test
    void testJavaxRequest() {
        Object adaptable = this.provider.getAdaptable((Object)this.javaxRequest, "child");
        Resource adaptableResource = ((SlingHttpServletRequest)adaptable).getResource();
        Assertions.assertEquals((Object)adaptableResource, (Object)this.childResource);
    }

    @Deprecated
    @Test
    void testJavaxRequestWhenChildDoesNotExist() {
        Assertions.assertNull((Object)this.provider.getAdaptable((Object)this.javaxRequest, "notexisting"));
    }
}

